<?php
/**------------------------------------------------------------------------
com_articleman -  Article Factory Manager 3.1.6
------------------------------------------------------------------------
 * @author TheFactory
 * @copyright Copyright (C) 2012 SKEPSIS Consult SRL. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: http://www.thefactory.ro
 * Technical Support: Forum - http://www.thefactory.ro/joomla-forum/
-------------------------------------------------------------------------*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class JHTMLEditArticle {

	function selectCategoryList($categoryId) {

		$database = JFactory::getDBO();
		$my = JFactory::getUser();
		$acl = JFactory::getACL();

		$options = JHTML::_('category.options','com_content',array('filter.published' => 1 ));

		require_once(JPATH_COMPONENT_SITE.DS.'config'.DS.'restrictions.php');
		$myGroups = $acl->getGroupsByUser($my->id,false);        

		foreach($myGroups as $gid) {
			if(isset($groupRestrictions[$gid])) {
				foreach($options as $k=>$option) {
					if(in_array( $option->value, $groupRestrictions[$gid] )) {
						unset($options[$k]);
					}
				}
			}
		}

		$opt = array('value'=>0,'text'=>JText::_('JOPTION_SELECT_CATEGORY'));
		array_unshift($options,$opt);

		return JHTML::_('select.genericlist',$options,'catid','','value','text',$categoryId);
	}

    function selectRevision($article) {        

        $db = JFactory::getDBO();
        $db->setQuery("SELECT * FROM `#__art_revisions` WHERE `contentId`='".$article->id."' ORDER BY `modified` DESC");
        $revisions = $db->loadObjectList();

        $options = array();
        $options[] = array('value'=>0,'text'=>JText::_('AMAN_SELECT_REVISION'));
        $c = count($revisions);
        foreach($revisions as $revision) {
            $value = $revision->id;
            $text = $revision->title . '('.JText::_('AMAN_REVISION').' '.$c--.' - '.$revision->modified.')';
            $options[] = JHTML::_('select.option',$value,$text);
        }

        $attribs = array();

        return JHtml::_('select.genericlist',$options,'revisionId',$attribs).'&nbsp;'.
            JHtml::link('#', JText::_('AMAN_PREVIEW_REVISION'), array('class'=>'modal','onclick'=>'return getRevisionId();','id'=>'previewRevisionLink','rel'=>'{handler: \'iframe\'}') ).'&nbsp'.
            '<input type="button" value="'.JText::_('AMAN_REVERT_TO_REVISION').'" onclick="restoreRevision();" />';
    }

    function attachFile($article) {
        
        $list = '<input type="file" name="article_upload_file" />';
        
        if($article->id) {
            $db = JFactory::getDBO();
            $db->setQuery("SELECT * FROM `#__art_articles_attachments` WHERE `contentId`='".$article->id."'");
    		$res = $db->loadObject();
    		if($res) {
    			global $option;
    			$href = JRoute::_('index.php?option='.$option.'&task=downloadatt&cloack='.$res->cloackName.'');
    			$text = $res->attachmentName.'.'.$res->attachmentExtension;
                $hrefDelete = JRoute::_('index.php?option='.$option.'&task=deleteatt&cloack='.$res->cloackName.'');
                $textDelete = JText::_('JACTION_DELETE');
    			$list = JHTML::link($href,$text).'&nbsp;('.JHtml::link($hrefDelete,$textDelete).')';
    		}
        }

        $html = JText::sprintf('AMAN_HELP_ARTICLE_UPLOAD_FILE',HTML_articleman_helper::maxUploadLimit()).'<br />'. $list;
        return $html;
    }
}
?>