<?php
/**------------------------------------------------------------------------
com_articleman -  Article Factory Manager 3.1.6
------------------------------------------------------------------------
 * @author TheFactory
 * @copyright Copyright (C) 2012 SKEPSIS Consult SRL. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: http://www.thefactory.ro
 * Technical Support: Forum - http://www.thefactory.ro/joomla-forum/
-------------------------------------------------------------------------*/

class articleACL {
	var $_my = null;
	var $_db = null;
	
	function __construct( &$db)
	{
		$this->_db = $db;
		$my = JFactory::getUser();
		if(isset($my))
		{
			$this->_my = $my;
		}
	}

    function &getInstance($db=null)
    {
        static $instance;

        if (!isset ($instance))
        {
            $database = JFactory::getDBO();
            if (!$db) $db=$database;

            $instance=new articleACL($database);
        }
        return $instance;
    }
    
    function hasEditorAccess()
	{
    	$acl = JFactory::getACL();
		$userGroups = $acl->getGroupsByUser($this->_my->id,false);
    	$aApprovingGroups = explode(',',_ART_SET_allowed_to_aprouve_groups);

		//if( ( $this->isUserSuperAdmin() || (count(array_intersect($userGroups,$aApprovingGroups)) ) ) )
        if( ( $this->isUserSuperAdmin() || (_ART_SET_onesuperadminonly==1 && count(array_intersect($userGroups,$aApprovingGroups)) ) ) )
		{
			return true;
	    }
	    return false;
    }

	function isUserSuperAdmin(){
		return $this->_my->authorise('core.login.admin');
	}

	function isAuthorizedPublisher()
	{
		$acl = JFactory::getACL();
		$userGroups = $acl->getGroupsByUser($this->_my->id,false);

		$aPublishingGroups = explode(',',_ART_SET_allowed_groups);
		$aApprovingGroups = explode(',',_ART_SET_allowed_to_aprouve_groups);

		if( count(array_intersect($userGroups,$aPublishingGroups)) || (_ART_SET_onesuperadminonly==1 && count(array_intersect($userGroups,$aApprovingGroups)) ) ){
			return true;
		}
		return false;

	}
	
	function isUserApproverGroup(){
		$aApprovingGroups = explode(',',_ART_SET_allowed_to_aprouve_groups);

		$acl = JFactory::getACL();
		$userGroups = $acl->getGroupsByUser($this->_my->id,false);

		if( count(array_intersect($userGroups,$aApprovingGroups)) )
		{
			return true;
		}
		return false;
	}
	
	function userHasApprove(){
		if($this->_my->authorise('core.admin'))
		{
			return true;
		}
        $sql = "SELECT count(*) FROM #__art_articles_ref WHERE approver_id = '{$this->_my->id}' ";
		$this->_db->setQuery($sql);
		if (!$this->_db->loadResult()) return false;
		else return true;
	}
	
	function isMyArticle($id) {
		$acl = JFactory::getACL();
		$userGroups = $acl->getGroupsByUser($this->_my->id,false);
		// admin or allowed to approve?
		$aApprovingGroups = explode(',',_ART_SET_allowed_to_aprouve_groups);
		if ($this->isUserSuperAdmin() || (_ART_SET_onesuperadminonly==1 && count(array_intersect($userGroups, $aApprovingGroups)) ) ){
			return true;
		} else {
			//check if it's mine
			$this->_db->setQuery("SELECT COUNT(*) FROM #__content WHERE id='$id' AND created_by='{$this->_my->id}'");
			if($this->_db->loadResult() ) {
                return true;
			}
            if( constant('_ART_SET_enable_revisions_system') ) {
                $this->_db->setQuery("SELECT COUNT(*) FROM #__art_revisions WHERE contentId='$id' AND created_by='{$this->_my->id}'");
                if($this->_db->loadResult() ) {
                    return true;
    			}
            }
            return false;
		}
	}
}

/**
 * Articleman Ancestral Class
 *
 */
class articleman_ancestor{
	
	function HTML_Status_list($filter, $draft_free = 0 ){
		$state[] = JHTML::_('select.option', '0', JText::_("AMAN_STATE") );
		$state[] = JHTML::_('select.option', '1', JText::_("AMAN_PENDING") );
		$state[] = JHTML::_('select.option', '2', JText::_("AMAN_PUBLISHED") );
		$state[] = JHTML::_('select.option', '3', JText::_("AMAN_UNPUBLISHED") );
		$state[] = JHTML::_('select.option', '4', JText::_("AMAN_REJECTED") );
		
		if($draft_free != "1"){
			$state[] = JHTML::_('select.option', '5', JText::_("AMAN_DRAFT") );
		}
		
		return  JHTML::_('select.genericList', $state, 'filter_state', 'class="inputbox" size="1" onchange="document.adminForm.submit( );"', 'value', 'text', $filter );
	}
	
	function HTML_cat_list($filter_catid )
	{
		$categories[] = JHTML::_('select.option', '0', JText::_("AMAN_SEL_CATEGORY"));
		$categories = array_merge( $categories, JHtml::_('category.options', 'com_content') );
		return JHTML::_('select.genericList', $categories, 'filter_catid', 'class="inputbox" size="1" onchange="document.adminForm.submit( );"', 'value', 'text', $filter_catid );
	}	

	function GetArticleState($id,&$lists){
		$database = &JFactory::getDBO();
		
		$artRef = JTable::getInstance('artxref');
        $artRef->load($id);

		$article = JTable::getInstance('content');
        $article->load($id);
        $state=$article->state;

		if ('rejected'==$artRef->state){
			$lists['state']=JText::_('AMAN_REJECTED');
		    $lists['reason']=$artRef->reason;
		}elseif ('pending'==$artRef->state){
		    $lists['state']=JText::_('AMAN_PENDING');
		    $chkfrontpage="checked";
		}elseif ($state=='1') {
		   $lists['state']=JText::_('AMAN_PUBLISHED');
        } else {
            $lists['state']=JText::_('AMAN_UNPUBLISHED');
        }
		return $lists['state'];
    }
        
    function GetRejectReasons(&$lists)
    {
		$database = &JFactory::getDBO();
		
		$database->setQuery("select * from #__art_reason order by title");
		$lists['reasons']=$database->loadObjectList('id');
		$reason_select[]=JHTML::_('select.option', '-1', ' - '.JText::_('AMAN_ARTICLE_CHOOSE_REASON').' - ', 'id', 'title' );
		$lists['reasonlist']=JHTML::_('select.genericList', array_merge($reason_select, $lists['reasons']), 'reason_list', 'class="inputbox" size="1" style="width:400px;" onchange="putReason(this.value)"', 'id', 'title', JRequest::getVar('reason') );
    }
        
    function deleteArticle($id)
    {
		$article = JTable::getInstance('content');
        $article->delete($id);
        
        if( constant('_ART_SET_enable_revisions_system') ) {
            $db = & JFactory::getDbo();
            $q = $db->getQuery(true);
            $q->delete('#__art_revisions');
            $q->where('contentId=\''.$db->getEscaped($id).'\'');
            $db->setQuery($q);
            $db->query();
        }
		
		$artRef = JTable::getInstance('artxref');
        $artRef->delete($id);
    }

	function changeState($chb,$publish,$nomessage=null) {

		$database = JFactory::getDBO();

        for ($i=0;$i<count($chb);$i++) {

		    $cb=$chb[$i];

            if( constant('_ART_SET_enable_revisions_system') ) {
                $rev = JTable::getInstance('artrevision');
                $row = $rev->loadByContentId($cb);
				$row->state = ( $publish ? 1 : 0 );
                $rev->store($row,'normal');

                // added 21 March
                $rev->changeStateRevisionId($cb,$row->state);

            } else {
                $row = JTable::getInstance('content');
                $row->load($cb);
                $row->state = ( $publish ? 1 : 0 );
                $row->store();
            }
			
			$artxref = JTable::getInstance('artxref');
			$artxref->load($row->id);
			$artxref->state = 'normal';
            //$artxref->state = $publish ? 'normal' : 'rejected';
			$artxref->store();

			switch($publish) {
				case 0:
					if(_ART_SET_unpublishEmail) {
						$this->sendMail($row,'unpublish');
					}
					break;				
				case 1:
					if(_ART_SET_acceptAuthorEmail) {
						$this->sendMail($row,'publish');
					}
					break;				
				case 2:				
					$this->sendMail($row,'publish_w_msg');
			 		break;
			}			
		}
	}
    	
	function rejectArticle($id,$reason)
	{
		$database = &JFactory::getDBO();

        if(_ART_SET_enable_revisions_system) {
            $rev = JTable::getInstance('artrevision');
            $res = $rev->loadByContentId($id);
			$content = $res;
        } else {
            $content = JTable::getInstance('content');
            $res = $content->load($id);
        }

		$msg='';
		if (!$res){
		    $msg=JText::_('AMAN_ERR_ARTICLE_NOT_EXISTS');
		} else {
		    $artRef = JTable::getInstance('artxref');
            $artRef->articleid = $id;
            $artRef->state = 'rejected';
            $artRef->reason = $reason;
            $artRef->store();

            $article = JTable::getInstance('content');
            $article->id = $id;
            $article->state = 0;
            $article->store();

            //added 21 march
            $rev = JTable::getInstance('artrevision');
            $row = $rev->loadByContentId($id);
            $rev->state = 0;
            $rev->store($res,'reject');

            // added 21 March
            $rev->changeStateRevisionId($id,$row->state);

            JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_content'.DS.'tables');
			$fp = JTable::getInstance('Featured','ContentTable');
            $fp->delete($id);

		    $msg=JText::sprintf('AMAN_ERR_ARTICLE_REJECTED','"'.$content->title.'"');

			$content->reason =  stripslashes($reason) ;
		    if(_ART_SET_rejectAuthorEmail) {
				$this->sendMail($content,'reject');
			}
		}
		return $msg;
	}

	function sendMail(&$article,$mailtype,$admin=null)
	{
		global $app;
		$database = &JFactory::getDBO();
		if(!$article->id)
		{
			return;
		}

		$database->setQuery("select id,subject,template from `#__art_emailtmpl` where `type`='$mailtype'");
		$template=null;
		$template = $database->loadAssoc();

		$subject=$template["subject"];
		$body=$template["template"];
		$user	= JTable::getInstance("user");
		$user->load($article->created_by);
		$link=JURI::root().'index.php?option=com_content&task=view&id='.$article->id;

		$searches = array(
			'%name%',
			'%username%',
			'%date%',
			'%url%',
			'%title%',
			'%reason%'
		);

		$replaces = array(
			$user->name,
			$user->username,
			JHTML::date($article->created),
			JHTML::link($link,$link),
			$article->title,
			$article->reason
		);
		$subject=str_replace($searches, $replaces, $subject);

		$searches[] = '%message%';
		$replaces[] = JRequest::getVar('message2authors');

		$body = str_replace($searches, $replaces, $body);

		$email = $user->email;
		if ($admin) {

            $artxref = JTable::getInstance('artxref');
            $artxref->load($article->id);
            if($artxref->approver_id) {
                $email = JFactory::getUser($artxref->approver_id)->email;
            } else {
                $email = constant('_ART_SET_mail_from_email') ? constant('_ART_SET_mail_from_email') : $app->getCfg('mailfrom');
            }
		}

		$from_name  = _ART_SET_mail_from_name!=""?_ART_SET_mail_from_name:$app->getCfg('sitename');
		$from_email = _ART_SET_mail_from_email!=""?_ART_SET_mail_from_email:$app->getCfg('mailfrom');

		JUtility::sendMail($from_email, $from_name, $email, $subject, $body, 1);
	}
    	
	function previewArt($id,$title=null,$intro=null,$main=null)
	{
		global $app;

        $id = JRequest::getVar('id',0,'default','int');
        if(_ART_SET_enable_revisions_system) {
            $rev = JTable::getInstance('artrevision');
            $article = $rev->loadByContentId($id);
        } else {
            $article = JTable::getInstance('content');
            $article->load($id);
        }

		ob_clean();
		if($intro=="" && $main==""){

		    if(!isset($title) || $title == null) $title = $article->title;
			if(!isset($intro) || $intro == null) $intro = $article->introtext;
		    if(!isset($main) || $main == null) $main = $article->fulltext;
				
			if ((!_ART_SET_allow_intro_html) && _ART_SET_intromain){
				$order   = array("\r\n", "\n", "\r");
				$replace = '<br />';
		        $intro=str_replace($order, $replace, $intro);
			    $intro=strip_tags($intro,'<br>');
			}
			
			if(_ART_SET_allowed_tags){
				$intro=strip_tags($intro,_ART_SET_allowed_tags);
				$main=strip_tags($main,_ART_SET_allowed_tags);
			}
			
			$intro = $article->introtext;
			$main  = $article->fulltext;
		}
		$template= JURI::base() . 'templates' . "/" . $app->getTemplate();
		
		echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en-gb\" lang=\"en-gb\" ><head><meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" /><title>$title</title><link href='$template/css/template.css' rel='stylesheet' type='text/css'></head>";
		echo "<body><table class='contentpaneopen' width='100%'><tbody><tr><td class='contentheading' width='100%'>$title</td></tr></tbody></table>";
		echo "<table class='contentpaneopen' width='100%'><tbody><tr><td colspan='2' valign='top'>$intro<br>$main</td></tr></tbody></table>";
		echo "</body></html>";
		exit;
	}

	function checkArticleForBannedWords($row){
		$text = strtolower(strip_tags($row->title." ".$row->introtext." ".$row->fulltext));
		$text = str_replace("-", " ", $text);
		$search   = array("\r\n", "\n", "\r"); $replace = ' ';
        $text = str_replace($search, $replace, $text);
		
        $found = array();
		$wordList = explode(",",_ART_SET_alert_words);
		
		foreach ($wordList as $wordKey => $wordValue){
			$patern = trim($wordValue);
			$patern = "\s".str_replace(" ", "(\s)*",$patern)."\s";
			$patern = '/'.$patern.'/';
			preg_match($patern,$text,$matches);
			if(count($matches)>0) $found[] = $wordValue;
    	}
    	if(count($found)>0) return $found;
    	else return false;
    }
    
    /**
     * Bind, strip, etc, posted article 
     *
     * @return article
     * @version 1.7.0
     */
    function processArticleFromPost() {
    	$article = array();
		
    	$article["id"] 			= JRequest::getVar('id');
		$article["title"]    	= stripslashes(JRequest::getVar("title"));

		if(_ART_SET_allowalias)
			$article["created_by_alias"]    	= stripslashes(JRequest::getVar("created_by_alias"));
		
		$article["start_date"]  = JRequest::getVar('date').' '.JRequest::getVar('date_hours','00').':'.JRequest::getVar('date_minutes','00').':00';
		$article["end_date"]  	= JRequest::getVar('end_date','00').' '.JRequest::getVar('end_date_hours','00').':'.JRequest::getVar('end_date_minutes','00').':00';
		$article["categorie"] 	= JRequest::getVar("catid");
		$article["metakey"] 	= JRequest::getVar("metakey");
		$article["metadesc"] 	= JRequest::getVar("metadesc");

		if(_ART_SET_content_style==0)
		{
			$article["intro"]  = stripslashes(JArrayHelper::getValue($_REQUEST,"introtext", ""));
			$article["main"]   = stripslashes(JArrayHelper::getValue($_REQUEST,"maintext", ""));
		}
		elseif(_ART_SET_content_style == 1)
		{
			$article["text"] 	= stripslashes(JArrayHelper::getValue($_REQUEST,"article_text", ""));
			$article["text"]	= str_replace('<br>', '<br />', $article["text"]);
			$pattern = '#<hr\s+id=("|\')system-readmore("|\')\s*\/*>#i';
			$tagPos	= preg_match($pattern, $article["text"]);
			if ($tagPos == 0) {
				$article["intro"]	= $article["text"];
			} else {
				list($article["intro"], $article["main"]) = preg_split($pattern, $article["text"], 2);
			}
        }

		$article["resourcebox"] = stripslashes(JArrayHelper::getValue($_REQUEST,'resourcebox', ""));
		$order   = array("\r\n", "\n", "\r");
        $replace = '<br />';
        // Processes \r\n's first so they aren't converted twice.
        $article["resourcebox"] = str_replace($order, $replace, $article["resourcebox"]);
        
            // intro, maintext manipulation
		if(_ART_SET_content_style==0){
			if ((!_ART_SET_allow_intro_html) && _ART_SET_intromain){
				$order   = array("\r\n", "\n", "\r");
				$replace = '<br />';
				
				$article["intro"] = str_replace($order, $replace, $article["intro"]);
				$article["intro"] = strip_tags($article["intro"],'<br>');
			}
		}elseif(_ART_SET_content_style == 1){
			if ((!_ART_SET_art_text_html)){
				$order   = array("\r\n", "\n", "\r");
				$replace = '<br />';

				$article["intro"]    = str_replace($order, $replace, $article["intro"]);
				$article["intro"]	 = strip_tags($article["intro"],'<br>');
				$article["main"]	 = str_replace($order, $replace, $article["main"]);
				$article["main"]	 = strip_tags($article["main"],'<br>');
			}
		}
		if(trim(_ART_SET_allowed_tags)!="")
			if(_ART_SET_allowed_tags){
				$article["intro"] = strip_tags($article["intro"],_ART_SET_allowed_tags);
				$article["main"] = strip_tags($article["main"],_ART_SET_allowed_tags);
			}
    	
    	if(_ART_SET_ticketpreapproval)
			$article["approver"] = JRequest::getVar("approver");
			
		return $article;
    }
    
    /**
     * Set article publish_up, publish_down, 
     *
     * @param $article
     * @param $start_date
     * @param $end_date
     * @version 1.7.0
     */
    function setArticleDates(&$article, $start_date, $end_date){
    	global $app;
    	$my =& JFactory::getUser();
		$database =& JFactory::getDBO();
		$config = JFactory::getConfig();

		$article->publish_up = strtotime($start_date);
		$offset = $config->getValue('config.offset');

		$date =& JFactory::getDate($article->publish_up, $offset);

		$article->publish_up = $date->toMySQL();

		// Handle never unpublish date
		$end_date = strtotime($end_date);
		if ( trim($end_date) == JText::_('ARTMAN_NEVER') || trim( $end_date ) == '' || trim( $end_date ) == '0000-00-00' || trim( $end_date ) == '0000-00-00 00:00:00')
		{
			$article->publish_down = $database->getNullDate();
		}
		else
		{
			$article->publish_down = $end_date;
			$date =& JFactory::getDate($article->publish_down, $app->getCfg('offset'));
			$article->publish_down = $date->toMySQL();
		}

        $gmdate = gmdate('Y-m-d H:i:s');
		if(!$article->id){
        	$article->created = $gmdate;
        }
		$article->modified = $gmdate;

        $article->modified_by=$my->id;
        $article->checked_out=0;
        $article->checked_out_time=$database->getNullDate();
	}

    function setArticleApprover(&$article, $approver ) {

        if( constant('_ART_SET_enable_revisions_system') ) {
            $rev =& JTable::getInstance('artrevision');
            $contentId = $rev->getLastRevision($article->id)->contentId;               
        } else {
            $contentId = $article->id;
        }

		$artRef = JTable::getInstance('artxref');
        $artRef->articleid = $contentId;
        $artRef->approver_id = $approver;
        $artRef->store();

        $this->sendMail($article,'pendingAdmin',1);
    }

    function atachResourceBox(&$row, $posted_resourceBox) {
    	$user =& JFactory::getUser();
		$resbox = $this->_getResourceBox($user->id);
		if(_ART_SET_enable_resourcebox=="1"){
			if(!CB_DETECT) {
				if(_ART_SET_allow_author_image=="1" && !empty($resbox->file) ) {
					jimport('joomla.filesystem.file');
					$file = "components/com_articleman/files/".$user->id.".".JFile::getExt($resbox->file);
					if($resbox->file_params=="left" || !isset($resbox->file_params))
						$signature = '<img src="'.$file.'" align="left">'.$posted_resourceBox;
					elseif($resbox->file_params=="right")
						$signature = $posted_resourceBox.'<img src="'.$file.'" align="right">';
				}else $signature = $posted_resourceBox;
				// Resource Box only added once (more specific at article created)
				if( ($row->id < 1) && _ART_SET_concat_resourcebox == "1") {
					echo $row->fulltext.="<br />".$signature;
				}
			}else {
				$file = "";
				if(_ART_SET_allow_author_image=="1" && $resbox->file!=""){
					$file = "images/comprofiler/".$resbox->file;
					if( strtolower($resbox->file_params)=="left" || !isset($resbox->file_params) )
						$signature = '<img src="'.$file.'" align="left">'.$resbox->text;
					elseif(strtolower($resbox->file_params)=="right")
						$signature = $posted_resourceBox.'<img src="'.$file.'" align="right">';
					$signature = '<img src="'.$file.'" align="left">'.$resbox->text;
				}else  $signature = $resbox->text;
				// Resource Box only added once (more specific at article created)
				if( ($row->id < 1) && _ART_SET_concat_resourcebox == "1") {
					echo $row->fulltext.="<br />".$signature;
				}
			}
		}
    }

    function _getResourceBox($user) {
	    global $cb_fieldmap;

    	$database = & JFactory::getDBO();
		$resbox=null;
		if(!CB_DETECT){
			$database->setQuery("select * from #__art_resourcebox where authorId='$user'");
			$resbox = $database->loadObject();
		} else
		{		
			$what = array();
			if($cb_fieldmap['avatar']) $what[] = $cb_fieldmap['avatar']." as file ";
			if($cb_fieldmap['text']) $what[] = $cb_fieldmap['text']." as text ";
			if($cb_fieldmap['file_params']) $what[] = $cb_fieldmap['file_params']." as file_params ";
			
			if(count($what)>0)
				$sql_what = implode(",", $what);
			else 
				$sql_what = " * ";
			$query="select $sql_what from #__comprofiler where user_id = ".$user;
			$database->setQuery($query);
			$resbox = $database->loadObject();

			if(isset($resbox->file_params))
				$resbox->file_params=strtolower($resbox->file_params);
		}
		return $resbox;
    }
    
    function word_count($html) {

	  # strip all html tags
	  $wc = strip_tags($html);
	
	  # remove 'words' that don't consist of alphanumerical characters or punctuation
	  $pattern = "#[^(\w|\d|\'|\"|\.|\!|\?|;|,|\\|\/|\-|:|\&|@)]+#";
	  $wc = trim(preg_replace($pattern, " ", $wc));
	
	  # remove one-letter 'words' that consist only of punctuation
	  $wc = trim(preg_replace("#\s*[(\'|\"|\.|\!|\?|;|,|\\|\/|\-|:|\&|@)]\s*#", " ", $wc));
	
	  # remove superfluous whitespace
	  $wc = preg_replace("/\s\s+/", " ", $wc);
	
	  # split string into an array of words
	  $wc = explode(" ", $wc);
	
	  # remove empty elements
	  $wc = array_filter($wc);
	
	  # return the number of words
	  return count($wc);
	
	}
	
	function countChars($html){
	  # strip all html tags
	  $wc = strip_tags($html);
	  $wc = str_replace(" ", "", $wc);
	  return strlen($wc);
	}
	
	function getUnpublishedArticles() {

		if(constant('_ART_SET_enable_revisions_system')) {
            $query = "SELECT id
				FROM #__art_revisions AS a
				LEFT JOIN #__art_articles_ref AS b
					ON a.id=b.articleid
				WHERE
					(a.state=0
					AND a.checked_out = 0
                    OR a.contentId=0)
                    AND b.state = 'pending'";
		} else {
            $query = "SELECT id
				FROM #__content AS a
				LEFT JOIN #__art_articles_ref AS b
					ON articleid = id
				WHERE
					a.state=0
					AND a.checked_out = 0
					AND b.state = 'pending'";
		}

        $database = JFactory::getDBO();
        $database->setQuery($query);

        return $database->loadResultArray();
	}

	function getPreApprovalArticles()
	{
        $user = &JFactory::getUser();
        $artACL = articleACL::getInstance();

        $approver = $user->authorise('core.admin') || $artACL->isUserApproverGroup();

        if(constant('_ART_SET_enable_revisions_system')) {
            $query = "SELECT a.contentId
				FROM #__art_revisions AS a
				LEFT JOIN #__content AS b
                    ON a.contentId=b.id AND a.modified<b.modified
                LEFT JOIN #__art_articles_ref AS c
					ON a.contentId=c.articleid
				WHERE
					a.state=0
					AND a.checked_out = 0 
                    AND b.modified IS NULL".
				($approver ?
					"" : " AND c.approver_id = '{$user->id}'
					AND a.created_by <> '{$user->id}' ").
                    ' AND c.state = \'pending\' ';
        } else {
            $query = "SELECT a.id
				FROM #__content AS a
				LEFT JOIN #__art_articles_ref AS b
					ON articleid = id
				WHERE
					a.state=0
					AND a.checked_out = 0
					AND b.state = 'pending' ".
				($approver ?
					"" : " AND b.approver_id = '{$user->id}'
					AND a.created_by <> '{$user->id}' ");
        }

		$database = &JFactory::getDBO();
        $database->setQuery($query);
//vardump($database->replacePrefix($database->getQuery()),1);
        return $database->loadResultArray();
	}

	function getNextArticle() {
		
	}

	/**
	 * Detect CB Integration
	 *
	 *
	 **/
    function _detectIntegration() {
    	$database = & JFactory::getDBO();
	    global $cb_fieldmap;
	    //detect CB
	    $database->setQuery("SELECT COUNT(1) FROM `#__extensions` WHERE `type`='component' AND `element`='com_comprofiler'");
	    if($database->loadResult()>0){
	    	define('CB_DETECT',1);
	    	$database->setQuery("select field,cb_field from #__art_cbfields");
	    	$r=$database->loadAssocList();
	    	for($i=0;$i<count($r);$i++){
	    		$cb_fieldmap[$r[$i]['field']]=$r[$i]['cb_field'];
	    	}
	    }else {
			define('CB_DETECT',0);
	    }
    }
    
	function checkin($article_id) {
		if ($article_id) {
			$article = & JTable::getInstance('content');
			return $article->checkin($article_id);
		}
		return false;
	}

	function checkout($article_id,$uid = null) {
		if ($article_id) {
			if (is_null($uid)) {
				$user	=& JFactory::getUser();
				$uid	= $user->get('id');
			}
			$article = & JTable::getInstance('content');
			return $article->checkout($uid, $article_id);
		}
		return false;
	}
	
	function getUsers($name,$javascript,$active,$nouser=null){
    	$db = & JFactory::getDBO();
    	$my = & JFactory::getUser();
    	if($my->id){
    		$and = " AND id <> {$my->id} ";
   		}
		$query = 'SELECT id AS value, name AS text'
		. ' FROM #__users'
		. ' WHERE block = 0'
		. $and
		;
		$db->setQuery( $query );
		if ( $nouser ) {
			$users[] = JHTML::_('select.option',  '0', '- '. JText::_( 'No User' ) .' -' );
			$users = array_merge( $users, $db->loadObjectList() );
		} else {
			$users = $db->loadObjectList();
		}

		return JHTML::_('select.genericlist',   $users, $name, 'class="inputbox" size="1" '. $javascript, 'value', 'text', $active );
		
	}
    
}


require_once(JPATH_SITE.DS.'components'.DS.'com_users'.DS.'models'.DS.'registration.php');

class FrontendModelSignup extends UsersModelRegistration
{
	public function register($temp)
	{
		$config = JFactory::getConfig();
		$params = JComponentHelper::getParams('com_users');

		// Initialise the table with JUser.
		$user = new JUser;
		$data = (array)$this->getData();

		// Merge in the registration data.
		foreach ($temp as $k => $v) {
			$data[$k] = $v;
		}

		// Prepare the data for the user object.
		$data['email']		= $data['email1'];
		$data['password']	= $data['password1'];
		$useractivation = $params->get('useractivation');

		// Check if the user needs to activate their account.
		if (($useractivation == 1) || ($useractivation == 2)) {
			jimport('joomla.user.helper');
			$data['activation'] = JUtility::getHash(JUserHelper::genRandomPassword());
			$data['block'] = 1;
		}

		// Bind the data.
		if (!$user->bind($data)) {
			$this->setError(JText::sprintf('COM_USERS_REGISTRATION_BIND_FAILED', $user->getError()));
			return false;
		}

		// Load the users plugin group.
		JPluginHelper::importPlugin('user');

		// Store the data.
		if (!$user->save()) {
			$this->setError(JText::sprintf('COM_USERS_REGISTRATION_SAVE_FAILED', $user->getError()));
			return false;
		}

		// Compile the notification mail values.
		$data = $user->getProperties();
		$data['fromname']	= $config->get('fromname');
		$data['mailfrom']	= $config->get('mailfrom');
		$data['sitename']	= $config->get('sitename');
		$data['siteurl']	= JUri::base();

		// Handle account activation/confirmation emails.
		if ($useractivation == 2)
		{
			// Set the link to confirm the user email.
			$uri = JURI::getInstance();
			$base = $uri->toString(array('scheme', 'user', 'pass', 'host', 'port'));
			$data['activate'] = $base.JRoute::_('index.php?option=com_users&task=registration.activate&token='.$data['activation'], false);

			$emailSubject = $this->getEmailSubject(12, $data);
			$emailBody    = $this->getEmailBody(12, $data);
		}
		else if ($useractivation == 1)
		{
			// Set the link to activate the user account.
			$uri = JURI::getInstance();
			$base = $uri->toString(array('scheme', 'user', 'pass', 'host', 'port'));
			$data['activate'] = $base.JRoute::_('index.php?option=com_users&task=registration.activate&token='.$data['activation'], false);

			$emailSubject = $this->getEmailSubject(11, $data);
			$emailBody    = $this->getEmailBody(11, $data);
		} else {

		  $emailSubject = $this->getEmailSubject(10, $data);
			$emailBody    = $this->getEmailBody(10, $data);
		}

		// Send the registration email.
		$settings = new LovefactorySettings();
		$return = JUtility::sendMail($data['mailfrom'], $data['fromname'], $data['email'], $emailSubject, $emailBody, $settings->html_notifications);

		// Check for an error.
		if ($return !== true) {
			$this->setError(JText::_('COM_USERS_REGISTRATION_SEND_MAIL_FAILED'));

			// Send a system message to administrators receiving system mails
			$db = JFactory::getDBO();
			$q = "SELECT id
				FROM #__users
				WHERE block = 0
				AND sendEmail = 1";
			$db->setQuery($q);
			$sendEmail = $db->loadResultArray();
			if (count($sendEmail) > 0) {
				$jdate = new JDate();
				// Build the query to add the messages
				$q = "INSERT INTO `#__messages` (`user_id_from`, `user_id_to`, `date_time`, `subject`, `message`)
					VALUES ";
				$messages = array();
				foreach ($sendEmail as $userid) {
					$messages[] = "(".$userid.", ".$userid.", '".$jdate->toMySQL()."', '".JText::_('COM_USERS_MAIL_SEND_FAILURE_SUBJECT')."', '".JText::sprintf('COM_USERS_MAIL_SEND_FAILURE_BODY', $return, $data['username'])."')";
				}
				$q .= implode(',', $messages);
				$db->setQuery($q);
				$db->query();
			}
			return false;
		}

		if ($useractivation == 1)
			return "useractivate";
		else if ($useractivation == 2)
			return "adminactivate";
		else
			return $user->id;
	}

  // Tasks
  function checkAvailability()
	{
	  $type  = JRequest::getVar('type',  '', 'POST', 'string');
	  $value = JRequest::getVar('value', '', 'POST', 'string');
      $db = JFactory::getDbo();

	  switch ($type)
	  {
	    case 'email':
	      if (!preg_match('/^([.0-9a-z_-]+)@(([0-9a-z-]+\.)+[0-9a-z]{2,4})$/i', $db->getEscaped($value)))
	      {
	        return false;
	      }

	      $query = ' SELECT u.id'
	             . ' FROM #__users u'
	             . ' WHERE u.email = "' . $db->getEscaped($value) . '"';
	    break;

	    default:
	      $query = ' SELECT u.id'
	             . ' FROM #__users u'
	             . ' WHERE u.username = "' . $db->getEscaped($value) . '"';
	    break;
	  }

        $db->setQuery($query);

	  return $db->loadResult() ? false : true;
	}

	/*public function validateForm()
	{
    // Check required Lovefactory fields
    $profile =& $this->getTable('profile', 'Table');

    $fields =& JModel::getInstance('fields', 'FrontendModel');
    $fields->getFieldsForPage('signup');
*/
    /* @var $profile TableProfile */
   /* $profile->updateFromFields($fields->_fields);

    if ($profile->_has_errors)
    {
      return false;
    }

    // Is photo required on registration?
    $photo_required    = $fields->getPhotoRequiredOnRegistration();
    $main_photo_upload = JRequest::getVar('main_photo_upload', '', 'POST', 'string');
    $valid_photo       = file_exists(JPATH_COMPONENT_SITE.DS.'storage'.DS.'registration_photos'.DS.$main_photo_upload);

    if ($photo_required && !$valid_photo)
    {
      JError::raiseWarning(0, JText::_('SIGNUP_TASK_SIGNUP_ERROR_UPLOAD_PHOTO'));
      return false;
    }

    return $profile;
	}
*/
/*	public function registerProfile($profile)
	{
	  $user_id = $this->getUserId();

	  // All went fine, register the Love Factory Profile
    $profile->user_id = $user_id;

    $profile->addDefaultInTable();
    $profile->createUserFolder();
    $profile->storeMainPhotoUpload();

    // Save the profile
    $profile->store();

    // Update fields location
    $settings = new LoveFactorySettings();
    if ($settings->fields_location)
    {
      $this->updateFieldsLocation($user_id, 'signup');
    }

    return true;
	}
*/
	protected function getUserId()
	{
	  $db      = JFactory::getDbo();
	  $jform    = JRequest::getVar('jform', array(), 'POST', 'array');
	  $username = $jform['username'];

	  $query = $db->getQuery(true)
	    ->select('u.id')
	    ->from('#__users u')
	    ->where('u.username = "' . $db->getEscaped($username) . '"');
	  $db->setQuery($query);

	  return $db->loadResult();
	}

	/*protected function updateFieldsLocation($user_id, $page)
	{
    $profile =& $this->getTable('profile', 'Table');
    $profile->user_id = $user_id;

    $fields =& JModel::getInstance('fields', 'FrontendModel');
    $fields->getFieldsForPage($page);
*/
    /* @var $profile TableProfile */
  /*  $profile->updateFromFields($fields->_fields, false);

    $profile->store();
	}*/

	protected function getEmailSubject($notification_id, $data)
	{
	  JModel::addIncludePath(JPATH_SITE.DS.'components'.DS.'com_lovefactory'.DS.'models');
	  $mailer = JModel::getInstance('Mailer', 'FrontendModel');

	  return $mailer->getSubjectForSignup($notification_id, $data);
	}

	protected function getEmailBody($notification_id, $data)
	{
	  JModel::addIncludePath(JPATH_SITE.DS.'components'.DS.'com_lovefactory'.DS.'models');
	  $mailer = JModel::getInstance('Mailer', 'FrontendModel');

	  return $mailer->getBodyForSignup($notification_id, $data);
	}
}

?>