<?php
/**------------------------------------------------------------------------
com_articleman -  Article Factory Manager 3.1.6
------------------------------------------------------------------------
 * @author TheFactory
 * @copyright Copyright (C) 2012 SKEPSIS Consult SRL. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: http://www.thefactory.ro
 * Technical Support: Forum - http://www.thefactory.ro/joomla-forum/
-------------------------------------------------------------------------*/

defined( '_JEXEC' ) or die( 'Restricted access' );
	
require_once(JPATH_SITE.DS.'components'.DS.'com_articleman'.DS.'class'.DS.'mainclass.php');

JLoader::register('HTML_articleman',JPATH_COMPONENT_SITE.DS.'articleman.html.php');

class articleman_front extends articleman_ancestor {

    var $html=null;

	function __construct() {

        $this->html = new HTML_articleman;
        require_once(JPATH_COMPONENT_SITE.DS.'articleman.xajax.php');
		$xajax = new JArticlemanXajax;
		$this->xajaxMethods =& $xajax->getXajaxMethods();
		require_once(JPATH_COMPONENT_SITE.DS.'helpers'.DS.'recaptcha'.DS.'jthefactoryrecaptcha.php');
		JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
    }
    
    function reBuildLists($row) {

    	$user = JFactory::getUser();
    	$database = JFactory::getDBO();

    	$lists = array();
    	$art_ref = JTable::getInstance('artxref');
    	$art_ref->load($row->id);
        
        $resourceBx = $this->_getResourceBox($user->id);

        if(isset($resourceBx->text)) {
        	$lists['resourcebox']=$resourceBx->text;
       	} else {
        	$lists['resourcebox']='';
       	}

        if(isset($resourceBx->file)) {
        	$lists['resourcebox_file']=$resourceBx->file;
       	} else {
        	$lists['resourcebox_file']='';
       	}

        $database->setQuery("select text from #__art_resourcebox where authorId='$user->id'");
        $lists['resourcebox']=$database->loadResult();

    	$lists['categorylist'] = JHTML::_('editarticle.selectCategoryList',$row->catid);
    	$lists['users']=$this->getUsers("approver", null, $art_ref->approver_id);
		
		return $lists;
    }
    
    function cancelEdit() {

    	global $app,$option;
        $option =  JRequest::getVar('option', 'com_adsman', 'REQUEST', 'word');

    	$user = JFactory::getUser();
	    $database = JFactory::getDBO();

        $id = JRequest::getVar('id',0,'default','int');

		$artACL = &articleACL::getInstance($database);
		if(!$id || !$artACL->isMyArticle($id)) {
			$app->redirect('index.php?option='.$option);
		}

    	if(_ART_SET_usecheckin) {
            $row = JTable::getInstance('content');
            $res = $row->load($id);

    		$row->checkin();
    	}

    	$app->redirect('index.php?option='.$option);
    }
    
    function validArticle(&$row,$resourcebox='') {
		$database = &JFactory::getDBO();
		$error = array();

        if(_ART_SET_content_style==0) {
        			if($row->introtext=='' && _ART_SET_required_intro!="0" && _ART_SET_showintro=="1") {
        			     $error[]=JText::_('AMAN_ERR_EMPTY_INTRO');
                    }
        			if (_ART_SET_required_main=='1' && _ART_SET_showmain=="1" && $row->fulltext=='') {
                        $error[]=JText::_('AMAN_ERR_EMPTY_TEXT');
                    }
        
        } elseif (_ART_SET_content_style==1) {
            if($row->introtext.$row->fulltext=='' && _ART_SET_art_text_required=="1") {
                $error[] = JText::_('AMAN_ERR_EMPTY_TEXT');
            }
        }

		if ($row->title=='') {
            $error[] = JText::_('AMAN_ERR_EMPTY_TITLE');
        }
		if ($row->catid<=0) {
            $error[] = JText::_('AMAN_ERR_EMPTY_CATEGORY');
		}

		if ($row->catid) {
			$database->setQuery("SELECT COUNT(*) FROM `#__categories` WHERE `id`='$row->catid'");
			if(!$database->loadResult()) {
                $error[]=JText::_('AMAN_ERR_EMPTY_CATEGORY');
			}
		}

		$stripped_string = strip_tags($row->introtext.$row->fulltext);
	
		if( ( _ART_SET_content_style ==0 && ( _ART_SET_required_intro + _ART_SET_required_main >= 1) ) || ( _ART_SET_content_style ==1 && ( _ART_SET_art_text_required >= 1) ) ) {
            if(trim(_ART_SET_limit_minim_chars)!="") {
                if(strlen($stripped_string) < _ART_SET_limit_minim_chars){
                    $error[] = JText::_('AMAN_ERR_TOO_LITLE_CHARS');
                }
            }
		}

		if(trim(_ART_SET_limit_maxim_chars)!="") {
            if(strlen($stripped_string) > _ART_SET_limit_maxim_chars) {
                $error[] = JText::_('AMAN_ERR_TOO_MANY_CHARS');
            }
		}

		$match_array = preg_split('/href/i',$row->introtext.$row->fulltext);
		$nrLinks = count($match_array)-1;

		$match_array = preg_split('/<img/i',$row->introtext.$row->fulltext);
		$nrImages = count($match_array)-1;
		
		$match_array =preg_split("/href/i",$resourcebox);
		$nrLinks_res = count($match_array)-1;
        if(_ART_SET_nrlinks) {
        	if (!$row->id && $nrLinks > _ART_SET_nrlinks) {
				$error[] = JText::_('AMAN_ERR_TOO_MANY_LINKS');
			}
			if ($row->id && $nrLinks > (_ART_SET_nrlinks + _ART_SET_nrlinks_resourcebox) ) {
				$error[] = JText::_('AMAN_ERR_TOO_MANY_LINKS');
			}
        }
			
        if(_ART_SET_nrimages && $nrImages > _ART_SET_nrimages ) {
            $error[] = JText::_('AMAN_ERR_TOO_MANY_IMAGES');
        }

		if (_ART_SET_nrlinks_resourcebox && $nrLinks_res > _ART_SET_nrlinks_resourcebox) {
            $error[] = JText::_('AMAN_ERR_TOO_MANY_LINKS_RESBOX');
		}

		return $error;
	}
	
	function uploadAttachment($article) {

		if(!_ART_SET_article_upload_file) {
			return false;
		}

		$uploadedAttachment = $_FILES['article_upload_file'];
		if(UPLOAD_ERR_NO_FILE == $uploadedAttachment['error']) {
            return true;
		}
		
		$attachment =& JTable::getInstance('artattachment');
		$attachment->cloackName = sha1($article->id);
		$attachment->contentId = $article->id;
		
		jimport('joomla.filesystem.file');
		if(! JFile::upload( $uploadedAttachment['tmp_name'], JPATH_COMPONENT_ADMINISTRATOR.DS.'attachments'.DS.$attachment->cloackName )) {
			return false;
		}

		$attachment->attachmentName = JFile::makeSafe(JFile::stripExt($uploadedAttachment['name']));
		$attachment->attachmentExtension = JFile::getExt(JFile::getName($uploadedAttachment['name']));

		return $attachment->store();
	}

	/**
	 * saveArticle
	 *  
	 * @modified: 16.05.2008 concats or not the maintext with the resourcebox text  ( _ART_SET_concat_resourcebox =1 ? concat; else not) 
	*/
    function saveArticle( $state, $anonymous=false ) {
    	global $option;
    	$app = JFactory::getApplication();

    	if($anonymous) {
            if( (bool) constant('_ART_SET_anonymous_captcha') ) {
            	$recaptcha_challenge_field = JRequest::getVar('recaptcha_challenge_field');
            	$recaptcha_response_field = JRequest::getVar('recaptcha_response_field');
            	$recaptchaResponse = JTheFactoryRecaptcha::check(_ART_SET_recaptcha_private_key,$recaptcha_challenge_field,$recaptcha_response_field);

                if(!$recaptchaResponse) {
            		JError::raiseWarning(1,'Bad CAPTCHA!');        			
            		$app->redirect('index.php?option='.$option.'&task=new');
                    return false;
                }
            }
            
            $anonymous_email = JRequest::getVar('anonymous_email');
            $validEmail = preg_match('/^([\w\!\#$\%\&\'\*\+\-\/\=\?\^\`{\|\}\~]+\.)*[\w\!\#$\%\&\'\*\+\-\/\=\?\^\`{\|\}\~]+@((((([a-z0-9]{1}[a-z0-9\-]{0,62}[a-z0-9]{1})|[a-z])\.)+[a-z]{2,6})|(\d{1,3}\.){3}\d{1,3}(\:\d{1,5})?)$/i',$anonymous_email);
            if(!$validEmail) {
            	JError::raiseWarning(1,'Bad email address!');
        		$app->redirect('index.php?option='.$option.'&task=new');
        		return false;
            }
    	}

        $user 		= JFactory::getUser();
        $acl 		= JFactory::getACL();
		$database 	= JFactory::getDBO();
		$my 		= JFactory::getUser();
		$Itemid     = JRequest::getVar('Itemid');
		$option     = JRequest::getVar('option');
		$artACL 	= &articleACL::getInstance($database);
		$artRef		= JTable::getInstance('artxref');

        $row = & JTable::getInstance('content');

		$post_article = $this->processArticleFromPost();

		$row->id= empty($post_article['id']) ? null : $post_article['id'];
		$isNew = $row->id < 1;

		/** start check category restrictions */
		require(JPATH_COMPONENT_SITE.DS.'config'.DS.'restrictions.php');
		$myGroups = $acl->getGroupsByUser($my->id,false);
		foreach($myGroups as $gid) {
			if(isset($groupRestrictions[$gid])) {
				foreach($options as $k=>$option) {
					if(in_array( $post_article['categorie'], $groupRestrictions[$gid] )) {
						$app->redirect(JROUTE::_('index.php?option='.$option),'You are not authorized to publish in the selected category!');
						return;
					}
				}
			}
		}
		/** end check category restrictions */

        if($isNew) {
        	$row->created = gmdate( 'Y-m-d H:i:s' );
			$row->created_by = $user->id;
			$row->created_by_alias	= "";
			$row->images= '';
			$row->urls= '';
			$row->attribs= '';
			$row->version= 1;
			$row->parentid= 0;
			$row->ordering	= 0;
			$row->access= 1;
			$row->hits= 0;
		} else {
        	if (!articleACL::getInstance()->isMyArticle($post_article['id'])) {
				return false;
			}
            if( constant('_ART_SET_enable_revisions_system') ) {
                $rev = JTable::getInstance('artrevision');
                $row = $rev->loadByContentId($post_article["id"]);
            } else {
                $row->load($post_article["id"]);
            }
			$row->version++;
        }

		$access = JRequest::getVar('access');
		$row->access = $access ? $access : 1;

        $row->title = $post_article['title'];
        $row->title_alias=$post_article['title'];

        if( $anonymous ) {
            $row->created_by_alias = $anonymous_email;
        } else if(_ART_SET_allowalias) {
            $row->created_by_alias = $post_article['created_by_alias'];
        }

        $row->alias	= JApplication::stringURLSafe($row->title);

        $row->introtext = preg_replace('/<script[^>]*?>.*?<\/script>/si','',@$post_article['intro']);
        $row->fulltext = preg_replace('/<script[^>]*?>.*?<\/script>/si','',@$post_article['main']);
        $row->catid	= $post_article['categorie'];

		$this->setArticleDates($row, $post_article["start_date"], $post_article["end_date"]);

        if (_ART_SET_allowmetdata) {
        	$row->metakey=$post_article["metakey"];
        	$row->metadesc=$post_article["metadesc"];
        }

        $row->state = 0;
		//this is somehow ugly, we need something better
        if($artACL->isAuthorizedPublisher() && 'pending'==$state) {
			$state = 'normal';
			$row->state = 1;
		}

        $row->check();
        $err = $this->validArticle($row, $post_article["resourcebox"]);

		if($err) {
	        $lists = $this->reBuildLists($row);
	        $lists['errors']=$err;
            $this->html->editArticle($row,$lists);
            return;
        }

		$this->atachResourceBox($row, $post_article["resourcebox"]);

		if( constant('_ART_SET_enable_revisions_system') ) {
            $rev =& JTable::getInstance('artrevision');
            $res = $rev->store($row,$state);

            // added 21 March
            $rev->changeStateRevisionId($post_article["id"],$row->state);
        } else {
            $res = $row->store();
        }

        if( !$res ) {
			$lists = $this->reBuildLists($row);
            $err = array_merge($err,$row->getErrors());
            JError::raiseNotice(1, implode( '<br />', $err ) );
			$this->html->editArticle($row,$lists);
			return;
		}

        //update the xReference table
        $oldstate = '';
        if($artRef->load($row->id)) {
            $oldstate = $artRef->state;
        }
        $artRef->articleid = $row->id;
        $artRef->state = $state;
        $artRef->store();

		$row->reorder('catid = ' . (int) $row->catid);

		$this->uploadAttachment($row);

		//  if set in config to publish on front
        if( 'normal' == $state && _ART_SET_publish_on_frontpage == 1 ) {
			JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_content'.DS.'tables');
			$fp = JTable::getInstance('Featured','ContentTable');

			if(!$fp->load($row->id)) {
            	$fp->content_id = $row->id;
            	$fp->ordering = 1;
            	$database->insertObject($fp->getTableName(),$fp,$fp->getKeyName());

            	$fp->reorder();
			}
        }

        if( 'pending'==$state ) {
            if(_ART_SET_ticketpreapproval && _ART_SET_userchoosesapprover) {
            	$this->setArticleApprover($row, $post_article["approver"] ? $post_article["approver"] : 42);
 			} else {
        		$this->setArticleApprover($row, 42);
        	}
        }

        $artRef->triggerMails($row, $oldstate,$state);

        switch ($state)
        {
            case 'pending':
                $msg = JText::_('AMAN_ARTICLE_SAVED_AND_PENDING');                    
                break;
            case 'normal':
                $msg = JText::_('AMAN_ARTICLE_PUBLISHED');
                break;
            case 'draft':
                $msg = JText::_('AMAN_ARTICLE_SAVED_AS_DRAFT');
                break;
        }

        if($anonymous) {
            $app->redirect( JRoute::_( JURI::base()."index.php?option={$option}&task=new&Itemid={$Itemid}") , $msg, "message");
        } else {
            $app->redirect( JRoute::_( JURI::base()."index.php?option={$option}&task=listArticles&Itemid={$Itemid}") , $msg, "message");
        }
    }
    
	function newArticle($anonymous=false) {

		$user = JFactory::getUser();
		$database = JFactory::getDBO();

		$row = & JTable::getInstance('content');
	    $lists=array();

        $resourceBx = $this->_getResourceBox($user->id);

        if(isset($resourceBx->text)) {
        	$lists['resourcebox']=$resourceBx->text;
       	} else {
        	$lists['resourcebox']='';
       	}
        if(isset($resourceBx->file)) {
        	$lists['resourcebox_file']=$resourceBx->file;
       	} else {            	
        	$lists['resourcebox_file']='';
       	}
        	
		if(!isset($resourceBx->file_params)) {
			$lists['resourcebox_file_params']="left";
		} else {
			$lists['resourcebox_file_params']=$resourceBx->file_params;
        }

		if(_ART_SET_default_publishing_period) {
			$defaultPublishingPeriod = (int) _ART_SET_default_publishing_period;
			$end_publish_date = mktime(0,0,0,date("m"),date("d")+$defaultPublishingPeriod,date("Y"));
			$row->publish_down = date("Y-m-d", $end_publish_date);
		}
		else
		{
			$row->publish_down = '0000-00-00 00:00:00';
		}

		if(_ART_SET_ticketpreapproval)
		{
			$lists['users']=$this->getApprovers();
		}

        $lists['categorylist'] = JHTML::_('editarticle.selectCategoryList',$row->catid);

        if($anonymous)
        {            	
        	$lists['recaptcha'] = JTheFactoryRecaptcha::initialize( constant('_ART_SET_recaptcha_public_key') );
        	$lists['anonymous_email'] = '<input type="text" name="anonymous_email" size="50" />';
        }
        
        if(_ART_SET_article_upload_file)
		{
			$lists['article_upload_file'] = '<input type="file" name="article_upload_file" />';
		}

		$this->html->editArticle($row,$lists,$anonymous);
	}
	
	function getApprovers(){
    	$db = JFactory::getDBO();
    	$my = JFactory::getUser();
    	$acl = JFactory::getACL();

    	$and = '';
		if($my->id){
    		$and .= " AND id <> {$my->id} ";
   		}
   		
   		$approvers = array();
   		if(strlen(trim(_ART_SET_allowed_to_aprouve_groups)))
   		{
			foreach(explode(',',_ART_SET_allowed_to_aprouve_groups) as $gid)
	   		{
	   			$approvers = array_merge($approvers,$acl->getUsersByGroup($gid));
   			}
   			foreach($approvers as $k=>$approver)
	   		{
	   			if($approver==$my->id)
	   			{
	   				unset($approvers[$k]);
	   			}
	   		}
   		}

   		if(count($approvers))
   		{
   			$and .= " AND id IN (".implode(',',$approvers).")";
   		}

		$query = 'SELECT id AS value, name AS text'
		. ' FROM #__users'
		. ' WHERE block = 0'
		. $and;

		$db->setQuery( $query );
		
		$users[] = JHTML::_('select.option',  '0', '- '. JText::_( 'No User' ) .' -' );
		$users = array_merge( $users, $db->loadObjectList() );

		return JHTML::_('select.genericlist',   $users, 'approver', 'class="inputbox" size="1" ', 'value', 'text' );
		
	}

	function editArticle() {

		$user       = JFactory::getUser();
	    $database   = JFactory::getDBO();
		//$id = JRequest::getVar('id');

		$art_ref = JTable::getInstance('artxref');
		$artACL = &articleACL::getInstance($database);

        $id = JRequest::getVar('id',0,'default','int');
        
        if( constant('_ART_SET_enable_revisions_system') ) {
            $rev = JTable::getInstance('artrevision');
            $row = $rev->loadByContentId($id);
            $res = $row->title;
        } else {
            $row = JTable::getInstance('content');
            $res = $row->load($id);
		}

        if(!$res) {
            echo JText::_('AMAN_ERR_ARTICLE_NOT_EXISTS');
			return;
        }
		$art_ref->load($row->id);

		//replace all the <br /> with \n for _ART_SET_art_text_html=0
		if(_ART_SET_content_style==0){
			if ((!_ART_SET_allow_intro_html) && _ART_SET_intromain){
				$replace   = "\r\n";
				$order = '<br />';

				$row->introtext = str_replace($order, $replace, $row->introtext);
			}
		} elseif (_ART_SET_content_style == 1) {
			if ((!_ART_SET_art_text_html)){
				$replace   = "\r\n";
				$order = '<br />';

				$row->introtext = str_replace($order, $replace, $row->introtext);
				$row->fulltext = str_replace($order, $replace, $row->fulltext);
				
			}
		}

		if(!$artACL->isMyArticle($row->id))
		{
			JError::raiseWarning(0, JText::_("ALERTNOTAUTH") );
		    return ;
		}
		
		if(_ART_SET_usecheckin){
			if($row->checked_out>0){
				$tmpUser = &JTable::getInstance("user");
				$tmpUser->load($row->checked_out);
				$row->checked_out_username = $tmpUser->name;
				unset($tmpUser);
				if( $row->checked_out != $user->id ){
					$row->checked_out_info = JText::_('AMAN_CHECKED_OUT')." ".$row->checked_out_username." - ".$row->checked_out_time." !";
				}
			}
			
			$this->checkout($id);
		}
		
	    $lists=array();

        $lists['categorylist'] = JHTML::_('editarticle.selectCategoryList',$row->catid);
		$lists['ref_state'] = $art_ref->state;

        // Select List: Category Ordering
		$query = 'SELECT ordering AS value, title AS text FROM #__content WHERE catid = '.(int) $row->catid.' AND state > ' .(int) "-1" . ' ORDER BY ordering';
		$lists['ordering'] = JHTML::_('list.specificordering', $row, $row->id, $query, 1);
		
		if(_ART_SET_ticketpreapproval && _ART_SET_userchoosesapprover) {
			//$lists['users']=$this->getUsers("approver", null, $art_ref->approver_id);
            $lists['users']=$this->getApprovers();
		}

        $this->html->editArticle($row,$lists);
	}

	function downloadAttachments() {
		$database = & JFactory::getDBO();
		
		$cloackName = JRequest::getVar('cloack');
		$database->setQuery("SELECT * FROM `#__art_articles_attachments` WHERE `cloackName`='".$database->getEscaped($cloackName)."'");
		$res = $database->loadObject();
		if(!$res)
		{
			return;
		}
		
		$file = JPATH_COMPONENT_ADMINISTRATOR.DS.'attachments'.DS.$res->cloackName;
		if(!is_file($file)){
			JError::raiseError(404,'File not found! (probably deleted)');
			return;
		}

		header('Content-type: application/'.$res->attachmentExtension);
		header('Content-Disposition: attachment; filename="'.($res->attachmentName.'.'.$res->attachmentExtension).'"');
		readfile($file);

		jexit();
	}

    function deleteAttachments() {

        global $app;
        $database = & JFactory::getDBO();
		
		$cloackName = JRequest::getVar('cloack');
		$artAtt = JTable::getInstance('artattachment');
        $artAtt->set('_tbl_key','cloackName');
		if(!$artAtt->load($cloackName)) {
			return;
		}
        $artAtt->set('_tbl_key','id');

        $contentId = $artAtt->contentId;
        if(!articleACL::getInstance()->isMyArticle($contentId)) {
            return;
        }
        jimport('joomla.filesystem.file');
        JFile::delete(JPATH_COMPONENT_ADMINISTRATOR.DS.'attachments'.DS.$artAtt->cloackName);

        $artAtt->delete();
        
        $app->redirect('index.php?option=com_articleman&task=editart&id='.$contentId);
    }
	
    function delArticle() {
        $Itemid = JRequest::getVar('Itemid', 0, 'REQUEST', 'integer');

        $app =& JFactory::getApplication();
		$user = &JFactory::getUser();
		$database = &JFactory::getDBO();
        $artAcl = articleACL::getInstance();
        
		$canDelete = $artAcl->isUserSuperAdmin() ? 1 : _ART_SET_canDelete;
        if (!$canDelete) {
			$app->redirect(JRoute::_(JURI::base().'index.php?option=com_articleman&task=articlesList&Itemid='.$Itemid),'NOT AUTH!');
			return false;
		}

        $id  = JRequest::getVar('id');
        if ($artAcl->isMyArticle($id) || $artAcl->isUserSuperAdmin() ) {
        	$this->deleteArticle($id);
        	$app->redirect(JRoute::_(JURI::base().'index.php?option=com_articleman&task=articlesList&Itemid='.$Itemid));
        	return true;
        }
    }
    
    function unpublishArticle() {
        global $app;
        $Itemid = JRequest::getVar('Itemid', 0, 'REQUEST', 'integer');
		$user = &JFactory::getUser();
		$database = &JFactory::getDBO();
		$acl = new articleACL($database);
                
		if(!$acl->isUserSuperAdmin()){
			if (!_ART_SET_canUnpublish){
				return;
			}
		}
		$id   = JArrayHelper::getValue($_REQUEST,"id");
		$article =& JTable::getInstance('content');
		$article->load($id);
		
        if (articleACL::getInstance()->isMyArticle($id) && $article->state==1){
        	$this->changeState(array($id),0,true);
        	$this->sendMail($article,'unpublish');
        }
		$app->redirect(JRoute::_(JURI::base().'index.php?option=com_articleman&task=articlesList&Itemid='.$Itemid));
    }
    
    function publishArticle() {
        global $app;
		$Itemid = JRequest::getVar('Itemid', 0, 'REQUEST', 'integer');
        $my = &JFactory::getUser();
		$database = &JFactory::getDBO();

        $artRef = JTable::getInstance('artxref');

		$id    = JArrayHelper::getValue($_REQUEST,"id");
		$article =& JTable::getInstance('content');
		$article->load($id);
        if (articleACL::getInstance()->isMyArticle($id) && $article->state==0) {
			//check if it is unpublished
            if($artRef->load($article->id)) {
                $oldstate = $artRef->state;
            } else {
                $artRef->articleid = $article->id;
            }

			if (!$this->testUserAccess()) {
				$artRef->state = 'pending';
                $artRef->store();

                if (_ART_SET_pendingAuthor=='1' && $oldstate!='pending'){
					$this->sendMail($article,'pendingAuthor');
                }
                if (_ART_SET_pendingAdmin=='1' && $oldstate!='pending'){
					$this->sendMail($article,'pendingAdmin',1);
				}
            } elseif($this->testUserAccess()) {
            	$artRef->state = 'normal';
                $artRef->store();

				$database->setQuery("UPDATE #__content SET state='1' WHERE id='$article->id'");
				$database->query();
				$this->sendMail($article,'publish');
            }
        }
		$app->redirect(JRoute::_(JURI::base().'index.php?option=com_articleman&task=articlesList&Itemid='.$Itemid));
    }
    
	function listArticles() {

        global $app;
		$user = &JFactory::getUser();
		$database = &JFactory::getDBO();
		$jconfig = new JConfig;
		$session = JFactory::getSession();
		$artACL = articleACL::getInstance($database);

		$limit = $jconfig->list_limit;
		
		$sess_sort_field = $session->get("sort_field");
		$sess_sort_ord = $session->get("sort_ord");
		if($sess_sort_field=="") {
			$sess_sort_field = "modified";
			$sess_sort_ord = "DESC";
			$session->set("sort_field", $sess_sort_field);
			$session->set("sort_ord", "DESC");	
		}

		$limit 			  = ($session->get("limit")!="")?$session->get("limit"):$limit;

		$state_default = null;
		if($artACL->hasEditorAccess()) {
			$state_default = 0;
		}
		$filter_state     = ($session->get("filter_state")!="") ? $session->get("filter_state") : $state_default;
		$filter_catid  	  = $session->get("filter_catid");

		$searchString     = $session->get("searchString");
		// other Advanced search requests
		$users     		  = $session->get("users");
		$start_date   	  = $session->get("start_date");
		$end_date   	  = $session->get("end_date");
		$m_start_date     = $session->get("m_start_date");
		$m_end_date   	  = $session->get("m_end_date");

		$limitstart		  = JRequest::getVar("limitstart", 0, 'default', 'int');
        $limit 			  = JRequest::getVar("limit",$limit, 'default', 'int');
	    $sortField 	  	  = JRequest::getVar("sort");

		$reset  	  	  = JRequest::getVar("reset","");

        if($reset=="") {
			$filter_state 	  = JRequest::getVar("filter_state", $filter_state, 'default', 'int');
			$filter_catid 	  = JRequest::getVar("filter_catid", $filter_catid, 'default', 'int');

			$searchString 	  = JRequest::getVar("searchstring",$searchString,'default','string');
			// other Advanced search requests
			//$users	 	  = JArrayHelper::getValue($_REQUEST,"users",$users);
			$start_date	 	  = JRequest::getVar("start_date",$start_date);
			$end_date 	 	  = JRequest::getVar("end_date",$end_date);
			$m_start_date 	  = JRequest::getVar("m_start_date",$m_start_date);
			$m_end_date  	  = JRequest::getVar("m_end_date",$m_end_date);
		} else {
			$filter_state	  = '';
			$filter_catid	  = '';
			$searchString	  = '';
			$start_date	 	  = '';
			$end_date 	 	  = '';
			$m_start_date 	  = '';
			$m_end_date  	  = '';
		}

		$filters = array();

		if($start_date!="") {
            $filters[JText::_("AMAN_CREATION_DATE")] = JText::_("AMAN_FROM")." ".$start_date;
		}
		if($end_date!="")
			if(isset($filters[JText::_("AMAN_CREATION_DATE")]))
				$filters[JText::_("AMAN_CREATION_DATE")] .= " ".JText::_("AMAN_TO")." ".$end_date;
			else 
				$filters[JText::_("AMAN_CREATION_DATE")] = JText::_("AMAN_TO")." ".$end_date;
			
		if($m_start_date!="")
			$filters[JText::_('AMAN_ARTICLE_LAST_UPDATE')] = JText::_("AMAN_FROM")." ".$m_start_date;
		if($m_end_date!="")
			if(isset($filters[JText::_('AMAN_ARTICLE_LAST_UPDATE')]))
				$filters[JText::_('AMAN_ARTICLE_LAST_UPDATE')] .= " ".JText::_("AMAN_TO")." ".$m_end_date;
			else 
				$filters[JText::_('AMAN_ARTICLE_LAST_UPDATE')] = JText::_("AMAN_TO")." ".$m_end_date;

		$this->html->showFilters($filters);

		if($sortField!="") {
			if( $sess_sort_field == $sortField ) {
				$session->set("sort_field", $sortField);
				if($sess_sort_ord == "ASC") {
					$session->set("sort_ord", "DESC");
					$sess_sort_ord = "DESC";
				} else {
					$session->set("sort_ord", "ASC");
					$sess_sort_ord = "ASC";
				}
			} else {
				$session->set("sort_field", $sortField);
				$session->set("sort_ord", "ASC");
				$sess_sort_ord = "ASC";
			}
		}

		$order = " {$sess_sort_field} {$sess_sort_ord}";

		$session->set("limitstart", $limitstart);
		$session->set("limit", $limit);
		$session->set("filter_state", $filter_state);
		$session->set("filter_catid", $filter_catid);
		
		$session->set("searchString", $searchString);
		$session->set("users", $users);
		$session->set("start_date", $start_date);
		$session->set("end_date", $end_date);
		$session->set("m_start_date", $m_start_date);
		$session->set("m_end_date", $m_end_date);


		$having = array();
        $where=array();
        if(!$artACL->hasEditorAccess()) {
			$where[] = "a.created_by='".$user->id."'";
		}

		if ($searchString) {
			$where[]= " (a.title like '%$searchString%' or a.introtext like '%$searchString%' or a.fulltext like '%$searchString%')";
		}

    	if($start_date) {
    	   $where[]= "a.created >= '".$start_date."'";
        }

    	if($end_date) {
            $where[]= "a.created <= '".$end_date."'";
        }

    	if($m_start_date) {
            $where[]= "a.modified >= '".$m_start_date."'";
        }

    	if($m_end_date) {
            $where[]= "a.modified <= '".$m_end_date."'";
        }

    	if($filter_catid) {
            $where[]= "a.catid='".(int) $filter_catid."'";
        }

        switch ($filter_state) {
			case 1://pending            
				$where[]= "a.state=0 and (coalesce(b.state,'pending')='pending')";
                if(_ART_SET_enable_revisions_system) {
                    $having[] = "src='revision'";
                }
				break;
			case 2://published
				$where[]= "a.state=1";
				break;
			case 3://unpublished
				$where[] = "a.state=0 and b.state='normal'";
				break;
			case 4://rejected
				$where[] = "a.state=0 and b.state='rejected'";
				break;
			case 5://draft
				$where[] = "a.state=0 and b.state='draft'";
				break;
		}

		if(!_ART_SET_enable_revisions_system) {

            $query_c= "select count(*)
                        from  #__content AS a
                        left join #__art_articles_ref as b on a.id = b.articleid "
        	.( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" );
        
            $database->setQuery($query_c);
            $total = $database->loadResult();

            $finalQuery = "SELECT a.id, a.catid, a.created, a.title, a.created_by,a.publish_up, a.hits, a.modified,a.checked_out , a.checked_out_time, a.state,
                    b.state AS rstate, b.reason, 
                    c.title AS categoryname,
                    u.name AS username,
                    us.name as checked_out_username ,
                    'content' AS src
		          FROM `#__content` AS a
		          LEFT JOIN `#__art_articles_ref` AS b
                    ON a.id=b.articleid 
		          LEFT JOIN #__categories AS c
                    ON c.id=a.catid
		          LEFT JOIN #__users AS u
                    ON u.id=a.created_by
		          LEFT JOIN #__users AS us
                    ON us.id=a.checked_out "
    		.( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" )
    		. ($order ? 'ORDER BY '.$order : '');
        
        } else {

            $total = 0;
            $query_c1= 'SELECT COUNT(*),\'content\' AS src
                FROM  `#__content` AS a
                LEFT JOIN #__art_articles_ref AS b
                    ON a.id = b.articleid '
	          .( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" )
              .( count($having) ? ' HAVING '.implode(' AND ',$having) : '');
            $database->setQuery($query_c1);
            $total += $database->loadResult();

            $query_c2= "select count(*),'revision' AS src
                from  `#__art_revisions` AS a
                left join `#__art_revisions` AS c
                    on a.contentId=c.contentId and a.modified<c.modified
                left join #__art_articles_ref as b on a.id = b.articleid "
	          . "\n WHERE c.modified IS NULL ". ( count( $where ) ?  ' AND '.implode( ' AND ', $where ) : "" )
              .( count($having) ? ' HAVING '.implode(' AND ',$having) : '');
            $database->setQuery($query_c2);
            $total += $database->loadResult();

            $query = "SELECT a.id AS id, a.catid, a.created, a.title, a.created_by,a.publish_up, a.hits, a.modified, a.checked_out, a.checked_out_time, a.state, a.id as contentId,
                        b.state AS rstate,
                        b.reason,
                        c.title AS categoryname,
                        u.name AS username,
                        us.name as checked_out_username ,
                        'content' AS src
    		          FROM `#__content` AS a
    		          LEFT JOIN `#__art_articles_ref` AS b
                        ON a.id=b.articleid 
    		          LEFT JOIN #__categories AS c
                        ON c.id=a.catid
    		          LEFT JOIN #__users AS u
                        ON u.id=a.created_by
    		          LEFT JOIN #__users AS us
                        ON us.id=a.checked_out "
                .( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" );

            $query_rev = "SELECT a.id AS id,a.catid,a.created, a.title,a.created_by,a.publish_up, a.hits, a.modified,a.checked_out , a.checked_out_time, a.state, a.contentId,
                       b.state AS rstate,
                       b.reason,
    		           c.title AS categoryname,
    		           u.name AS username,
                       us.name as checked_out_username ,
                       'revision' AS src
    		          FROM  #__art_revisions AS a 
    		          LEFT JOIN #__art_articles_ref AS b
                        ON a.contentId=b.articleid 
    		          LEFT JOIN #__categories AS c
                        ON c.id=a.catid
    		          LEFT JOIN #__users AS u
                        ON u.id=a.created_by
    		          LEFT JOIN #__users AS us
                        ON us.id=a.checked_out "
                .( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" );

            $finalQuery = 'SELECT uni1.contentId AS id,uni1.catid,uni1.created,uni1.title,uni1.created_by,uni1.publish_up,uni1.hits,uni1.modified,uni1.checked_out , uni1.checked_out_time,uni1.state,uni1.rstate,
                       uni1.reason,
    		           uni1.categoryname,
    		           uni1.username,
                       uni1.checked_out_username ,
                       uni1.src,
                       uni1.id AS articleId
                       FROM
                        (('.$query.') UNION ('.$query_rev.')) AS uni1
                        LEFT JOIN
                        (('.$query.') UNION ('.$query_rev.')) AS uni2
                        ON IF(uni1.contentId, uni1.contentId=uni2.contentId, uni1.id=uni2.id)
                        AND uni1.modified<uni2.modified
                        WHERE uni2.modified IS NULL '.
                        ( count($having) ? ' HAVING '.implode(' AND ',$having) : '').
                        ' ORDER BY '.($order ? 'uni1.'.$order : ' uni1.modified DESC ');
        }

        $database->setQuery($finalQuery,$limitstart, $limit);
        $rows=$database->loadObjectList();

		$lists['state'] = $this->HTML_Status_list($filter_state);
		$lists['catid'] = $this->HTML_cat_list($filter_catid);
		$lists['searchString']=$searchString;

    	jimport('joomla.html.pagination');
        $pageNav = new JPagination( $total, $limitstart, $limit );

    	$this->html->artList($rows,$pageNav,$lists);
	}
	
	/**
	 * delete AF ResourceBox Image
	 * 
	 * @version 1.7.0
	 */
	function deleteResourceBoxImage() {

        $app = JFactory::getApplication();
        $Itemid = JRequest::getVar('Itemid', 0, 'REQUEST', 'integer');
        jimport('joomla.filesystem.file');
        $user = &JFactory::getUser();
        $database = &JFactory::getDBO();
        
        $database->setQuery("select * from #__art_resourcebox where authorId='$user->id'");
        $resbox=null;
        $resbox = $database->loadAssoc();
        
        $fileName = JPATH_BASE.DS."components".DS."com_articleman".DS."files".DS.$user->id.".".JFile::getExt($resbox["file"]);
		if(file_exists($fileName)) {
			JFile::delete($fileName);
			$database->setQuery("UPDATE #__art_resourcebox SET file = '' WHERE authorId='$user->id'");
			$database->query();
			$app->redirect(JRoute::_(JURI::base()."index.php?option=com_articleman&Itemid=$Itemid&task=rsBox") ,JText::_('AMAN_RESOURCEBOX_DELETED'));
		}
	}
	
	function resourceBox() {

        $user = &JFactory::getUser();
        $database = &JFactory::getDBO();

        $database->setQuery("select * from #__art_resourcebox where authorId='$user->id'");
        $resbox=null;
        $resbox = $database->loadAssoc();

        $this->html->resourceBoxForm($resbox);
	}
	
	function saveResourceBox() {
		global $app;
		jimport('joomla.filesystem.file');
        
		$Itemid = JRequest::getVar('Itemid', 0, 'REQUEST', 'integer');
		$user = &JFactory::getUser();
		$database = &JFactory::getDBO();
		
		if(is_uploaded_file($_FILES["profile_image"]["tmp_name"])) {
			if( strpos(_ART_SET_allowed_extensions , strtolower(JFile::getExt($_FILES["profile_image"]["name"])) ) !== false) {
				$fileName = JPATH_BASE.DS."components".DS."com_articleman".DS."files".DS.$user->id.".".JFile::getExt($_FILES["profile_image"]["name"]);
				if(JFile::upload($_FILES["profile_image"]["tmp_name"], $fileName)) {
					$size = $_FILES["profile_image"]["size"]/1024;
					// file too big!! return from here
					if($size>_ART_SET_max_size)
						$app->redirect(JRoute::_(JURI::base()."index.php?option=com_articleman&Itemid=$Itemid&task=rsBox"),JText::_('AMAN_ERR_IMAGE_TOO_BIG'));
					$file = $_FILES["profile_image"]["name"];
				}
			}else
				$app->redirect(JRoute::_(JURI::base()."index.php?option=com_articleman&Itemid=$Itemid&task=rsBox"),JText::_('AMAN_ERR_NOT_ALLOWED_EXTENSION'));
			
		}
		
		$text = JArrayHelper::getValue($_REQUEST, "resourcebox");
		$alignment = JArrayHelper::getValue($_REQUEST, "alignment");
		
		$file_sql = "";
		if($file!="")
			$file_sql = " , file='$file' ";

        //$text= strip_tags($text,'<a>');
		$ifExistRs = "select count(*) from #__art_resourcebox where authorId = $user->id";
		$database->setQuery($ifExistRs);
		if ($database->LoadResult()) {
			$database->setQuery( "update #__art_resourcebox set text='$text' {$file_sql} , file_params ='$alignment' where authorId = '$user->id'");
			$database->query();
		} else {
			$database->setQuery( "insert into #__art_resourcebox set text='$text' {$file_sql}, file_params ='$alignment', authorId = '$user->id'");
			$database->query();
		}

		$app->redirect(JRoute::_(JURI::base()."index.php?option=com_articleman&Itemid=$Itemid&task=rsBox"),JText::_('AMAN_RESOURCEBOX_SAVED'));
	}

	function previewArticle($anonymous=false)
	{
		global $app;
		$editor		= & JFactory::getEditor();
		$id			= JRequest::getVar('id');

		$document	=& JFactory::getDocument();
		$document->setLink(JURI::root());

		ob_clean();
		ob_start();
		JHTML::_('behavior.caption');

		?>
		<script>
		var form = window.top.document.adminForm
		var title = form.title.value;

<?php if(_ART_SET_content_style==0) { ?>
		introtext = window.top.getIntroText();
		maintext = window.top.getMainText();
<?php } elseif (_ART_SET_content_style==1){ ?>
		introtext = '';
		maintext = window.top.getArticleText();
<?php } ?>
		alltext = introtext + "<br />" + maintext;
		alltext=alltext.replace(/\n/gi,'<br />');				
		</script>
		<?php
		$template= JURI::base() . 'templates' . "/" . $app->getTemplate();
		?>
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-gb" lang="en-gb" >
			<head>
				<meta http-equiv="content-type" content="text/html; charset=utf-8" />
				<title>
					<script>document.write(title)</script>
				</title>
				<link href="<?php echo $template."/css/template.css"; ?>" rel="stylesheet" type="text/css" />
			</head>
			<body>
				<table class="contentpaneopen" width="100%">
					<tbody>
						<tr>
							<td class="contentheading" width='100%'>
								<script>document.write(title);</script>
							</td>
						</tr>
					</tbody>
				</table>
				<table class='contentpaneopen' width='100%'>
					<tbody>
						<tr>
							<td colspan='2' valign='top'>
								<script>document.write(alltext);</script>
							</td>
						</tr>
					</tbody>
				</table>
			</body>
		</html>
		<?php
		echo ob_get_clean();
		exit;
		
	}
    function list_previewArticle() {

		$database = &JFactory::getDBO();
        $id    	  = JRequest::getVar('id');
        $title 	  = urldecode(JRequest::getVar('title_encoded'));
		
		$main = '';
        if(_ART_SET_content_style==0) {
			$intro  = JArrayHelper::getValue($_POST,'introtext');
			$main 	= JArrayHelper::getValue($_POST, 'maintext');
			$intro = stripcslashes($intro);
			$main = stripcslashes($main);
		} elseif(_ART_SET_content_style == 1) {
			$text 	= JArrayHelper::getValue($_POST,'maintext');
			$text	= str_replace('<br>', '<br />', $text);
			$text = stripcslashes($text);
			$pattern = '#<hr\s+id=("|\')system-readmore("|\')\s*\/*>#i';
			$tagPos	= preg_match($pattern, $text);
			if ($tagPos == 0) {
				$intro	= $text;
			} else {
				list($intro, $main) = preg_split($pattern, $text, 2);
			}
        }

        if ($id && !articleACL::getInstance()->isMyArticle($id)) {
        	JError::raiseError( 404, JText::_('ALERTNOTAUTH'));
            return;
        }
    	$this->previewArt($id,$title,$intro,$main);
    }
    
	function search() {
		$user = &JFactory::getUser();
		$database = &JFactory::getDBO();
		$session = &JFactory::getSession();
		$users = array();
		$query = 'SELECT id AS value, name AS text'
		. ' FROM #__users'
		. ' WHERE block = 0'
		;
		$database->setQuery( $query );
		if ( isset($nouser) ) {
			$users[] = JHTML::_('select.option',  '0', '- '. JText::_( 'No User' ) .' -' );
			$users = array_merge( $users, $database->loadObjectList() );
		}else {
			$users = $database->loadObjectList();
		}
		$lists["users"] = JHTML::_('select.genericlist', $users, "users", 'class="inputbox" style="width:250px;" multiple="multiple" ', 'value', 'text' );
		
    	$this->html->showSearchForm($lists);
    }
    
	/**
	 * Approve Article task
	 *
	 */
	function aprouveArticle(){
        global $app;

		$user = &JFactory::getUser();
		$acl = & JFactory::getACL();
		$database = &JFactory::getDBO();
		$my = &JFactory::getUser();
		$Itemid     = JRequest::getVar("Itemid");
		$option     = JRequest::getVar("option");
		
		$post_article = $this->processArticleFromPost();

		if(constant('_ART_SET_enable_revisions_system')) {
            $rev=& JTable::getInstance('artrevision');
            $row = $rev->loadByContentId($post_article["id"]);
        } else {
            $row=& JTable::getInstance('content');
            $row->load($post_article["id"]);
        }

		$isNew = $post_article["id"] < 1;

        $row->version++;
        $row->title=$post_article["title"]; $row->title_alias=$post_article["title"];
        $row->introtext=preg_replace('/<script[^>]*?>.*?<\/script>/si','',$post_article["intro"]);
        $row->fulltext=preg_replace('/<script[^>]*?>.*?<\/script>/si','',$post_article["main"]);
        $row->catid	=$post_article["categorie"];

        $row->state=1;
        
        $this->setArticleDates($row, $post_article["start_date"], $post_article["end_date"]);

        if (_ART_SET_allowmetdata){
        	$row->metakey=$post_article["metakey"];
        	$row->metadesc=$post_article["metadesc"];
        }
        
		$state = 'normal';
        $row->check();
        
        $err = $this->validArticle($row);

        if($err){
	        $lists = $this->reBuildLists($row);
	        $lists['errors']=$err;
            $this->html->aprouveArticle($row,$lists);
            return;
        }

        if( constant('_ART_SET_enable_revisions_system') )
        {
            $revision =& JTable::getInstance('artrevision');
            $revision->store($row,$state,'revision');               
        } else {
            $row->store();
        }

        //  if set in config to publish on front
        if(_ART_SET_publish_on_frontpage == "1")
		{
			JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_content'.DS.'tables');
			$fp =& JTable::getInstance('Featured','ContentTable');

			if(!$fp->load($row->id))
			{
            	$fp->content_id = $row->id;
            	$fp->ordering = 1;
            	$database->insertObject($fp->getTableName(),$fp,$fp->getKeyName());

            	$fp->reorder();
			}
        }

    	$artRef = JTable::getInstance('artxref');
        if($artRef->load($row->id)) {
            $oldstate = $artRef->state;
        } else {
            $artRef->articleid = $row->id;
        }
        $artRef->state = $state;

        $artRef->store();

        // New
		if(!isset($oldstate)){
			switch ($state){
				case "pending":
		        	if (_ART_SET_pendingAuthor=='1'){
		            	$this->sendMail($row,'pendingAuthor');
		            }
		        	if (_ART_SET_pendingAdmin=='1'){
		            	$this->sendMail($row,'pendingAdmin',1);
		        	}
				break;
				case "normal":
		        	if (_ART_SET_acceptAuthorEmail=='1'){
		            	$this->sendMail($row,'publish');
		            }
				break;
			}
		}
		else
		{
			if($oldstate!="pending"){
	        	if (_ART_SET_pendingAuthor=='1'){
	            	$this->sendMail($row,'pendingAuthor');
	            }
	        	if (_ART_SET_pendingAdmin=='1'){
	            	$this->sendMail($row,'pendingAdmin',1);
	        	}
			}
		}

        $app->redirect( JRoute::_( JURI::base()."index.php?option={$option}&task=aprouve&Itemid={$Itemid}") , JText::_('AMAN_ARTICLE_PUBLISHED'), "message");
	}

    function reject_article() {
    	$app = JFactory::getApplication();
        $option =  JRequest::getVar('option', 'com_adsman', 'REQUEST', 'word');
        $Itemid = JRequest::getVar('Itemid', 0, 'REQUEST', 'integer');
    	$db = JFactory::getDbo();

		$artAcl = new articleACL($db);        	

		if(!$artAcl->hasEditorAccess())
		{
			JError::raiseWarning(0, JText::_("ALERTNOTAUTH") );
			$app->redirect( JRoute::_( JURI::base()."index.php?option={$option}&Itemid={$Itemid}"));
		}

		$cid = JRequest::getVar('cid');
		if(is_array($cid)) $id = $cid[0];
		if(isset($cid[1])) $getnextpending = $cid[1];
        
        $id = JRequest::getVar('id',0,'default','int');
		$reason = addslashes(JRequest::getVar('message2authors'));

	    if( $id ) {

			$msg = $this->rejectArticle($id,$reason);
			if(!empty($getnextpending) )
			{
				$app->redirect("index.php?option=$option&task=aprouve&Itemid=$Itemid&id=$getnextpending",$msg);
			}
			else
			{
				$app->redirect("index.php?option=$option",$msg);
			}
	    }
    }
    
    function aprouve()
	{
    	global $app, $option;
        $option =  JRequest::getVar('option', 'com_adsman', 'REQUEST', 'word');
        $Itemid = JRequest::getVar('Itemid', 0, 'REQUEST', 'integer');
		$user = &JFactory::getUser();
	    $database = & JFactory::getDBO();
		$artACL = &articleACL::getInstance($database);

	    $lists=array();
	    
		if(!$artACL->isUserApproverGroup() && !$artACL->userHasApprove()){
			JError::raiseWarning(403, JText::_("ALERTNOTAUTH") );
			$app->redirect( JRoute::_( JURI::base()."index.php?option={$option}&Itemid={$Itemid}"));
		}

		$id=JRequest::getVar('id',0,'default','int');

		$lists['cid'] = array();
        if($artACL->isUserApproverGroup()) {
            $lists['cid'] = $this->getUnpublishedArticles();
		}

		if($artACL->userHasApprove()) {
            $lists['cid'] = $this->getPreApprovalArticles();
		}

        $lists['left_count'] = count($lists['cid']);

        if(!$id) {
			$id = (int) reset($lists['cid']);
		}

        if(constant('_ART_SET_enable_revisions_system')) {
            $rev = JTable::getInstance('artrevision');
            $row = $rev->loadByContentId($id);
            $res = true;
        } else {
            $row = JTable::getInstance('content');
            $res = $row->load($id);
        }

		if ( !$id || !$res ) {
			JError::raiseNotice(1,JText::_('AMAN_ERR_NO_MORE_ARTICLES'));
			return;
		}

		$user	= & JTable::getInstance("user");
		$user->load($row->created_by);

		$row->user = $user;
		$row->word_banned = $this->checkArticleForBannedWords($row);

		// Select List: Category Ordering
		$query = 'SELECT ordering AS value, title AS text FROM #__content WHERE catid = '.(int) $row->catid.' ORDER BY ordering';
		$lists['ordering'] = JHTML::_('list.specificordering', $row, $row->id, $query, 1);

        $database->setQuery("select * from #__art_resourcebox where authorId='$user->id'");
        $resourceBx = $database->loadObject();
        if( is_object($resourceBx) ) {
			$lists['resourcebox']=$resourceBx->text;
        }

		$this->GetRejectReasons($lists);
        $lists["word_count_intro"] = $this->word_count($row->introtext);
        $lists["word_count_full"] = $this->word_count($row->fulltext);
        $lists["char_count_intro"] = $this->countChars($row->introtext);
        $lists["char_count_full"] = $this->countChars($row->fulltext);

        $artRef = JTable::getInstance('artxref');
        $artRef->load($id);
        $lists['ref_state'] = $artRef->state;

        $lists['categorylist'] = JHTML::_('editarticle.selectCategoryList',$row->catid);

		$this->html->aprouveArticle($row,$lists);
    }

    function generaterejectform()
	{
		$lists = array();
		$this->GetRejectReasons($lists);
		HTML_articleman::generaterejectform($lists);
	}

    function previewrevision()
    {
        $id = JRequest::getVar('id',0,'default','int');
        $revision = JTable::getInstance('artrevision');
        $revision->load($id);
        ob_clean();

        HTML_articleman::previewRevision($revision);
    }

    function restorerevision()
    {
        $app = JFactory::getApplication();
        $id = JRequest::getVar('id',0,'default','int');
        $revision = JTable::getInstance('artrevision');
        $revision->load($id);
        $article = JTable::getInstance('content');
        $article->load($revision->contentId);

        $artACL = &articleACL::getInstance(JFactory::getDbo());
        if(!$artACL->isMyArticle($article->id))
		{
			JError::raiseWarning(0, JText::_("ALERTNOTAUTH") );
		    return ;
		}

        $article->bind( JArrayHelper::fromObject($revision) );
        $article->id = $revision->contentId;
        $revision->id = null;
        if($revision->store($article,'normal') )
        {
            $msg = JText::_('AMAN_REVISION_RESTORED');
        } else {
            $msg = JText::_('AMAN_REVISION_RESTORED_ERR');
        }

        $app->redirect('index.php?option=com_articleman',$msg);
    }

    function signup(){
        $user = JFactory::getUser();
        $Itemid = JRequest::getVar('Itemid', 0, 'REQUEST', 'integer');
        $mainframe	 = JFactory::getApplication();
        if ($user->guest)
        {
            $uri     = JFactory::getURI();
            $referer = base64_encode($uri->toString());

            $mainframe->redirect(
              'index.php?option=com_users&view=login&Itemid=' . $Itemid . '&return=' . $referer,
              JText::_('PERMISSIONS_LOGIN')
            );
        }
    }


}

?>