<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_updateproducts
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
 
// No direct access to this file
defined('_JEXEC') or die('Restricted access');
 
/**
 * General Controller of update products component
 *
 * @package     Joomla.Administrator
 * @subpackage  com_updateproducts
 * @since       0.0.7
 */
class UpdateProductsController extends JControllerLegacy
{
	/**
	 * The default view for the display method.
	 *
	 * @var string
	 * @since 12.2
	 */   
	protected $default_view = 'updateproducts';
        
        public function exportproducts()
        {
            $plist = array();
            $categories = array("21","22");            
            $model = VmModel::getModel('product');            
           
            foreach($categories as $cat)
            {    
                $productlist = $model->getProductListing(false,false,false,false,true,TRUE,$cat);
            
                foreach ($productlist as $product) 
                {
                 
                    $virtuemart_product_id  = $product->virtuemart_product_id;
                    $virtuemart_category_id = $product->virtuemart_category_id;
                    
                    $siteurl = str_replace("administrator/","",JURI::base());
                            
                    $plist[$virtuemart_product_id]['virtuemart_product_id'] = $product->virtuemart_product_id;
                    $plist[$virtuemart_product_id]['product_sku']  = $product->product_sku;
                    $plist[$virtuemart_product_id]['product_name'] = $product->product_name;
                    $plist[$virtuemart_product_id]['virtuemart_category_id'] = $product->virtuemart_category_id;              
                    $plist[$virtuemart_product_id]['category_name'] = $product->category_name;
                    $plist[$virtuemart_product_id]['product_price'] = $product->product_price;

                    $medmodel = VmModel::getModel('media');
                    $files    = $medmodel->getFiles(false,false,$virtuemart_product_id,$virtuemart_category_id);   
                    $file_url = 0;
                    $file_url_thumb = 0;
                    
                    if(isset($files[0]->file_url) && $files[0]->file_url!='')
                    {    
                        $file_url = $siteurl.$files[0]->file_url;
                    }
                    
                    if(isset($files[0]->file_url_thumb) && $files[0]->file_url_thumb!='')
                    {    
                        $file_url_thumb = $siteurl.$files[0]->file_url_thumb; 
                    }
                    
                    $plist[$virtuemart_product_id]['image_url'] = $file_url;
                    $plist[$virtuemart_product_id]['image_thumb_url'] = $file_url_thumb; 
                    $plist[$virtuemart_product_id]['virtuemart_media_id'] = isset($files[0]->virtuemart_media_id)?$files[0]->virtuemart_media_id:""; 
                  
                }
               
            } 
            
            $filename = "Export_products_".time().".csv";
            $fp = fopen('php://output', 'w');
            header('Content-type: application/csv');
            header('Content-Disposition: attachment; filename=' . $filename);

            $header = array("virtuemart_product_id","product_sku","product_name","product_price","virtuemart_category_id","category_name","image_url","image_thumb_url","virtuemart_media_id");              
            fputcsv($fp, $header);
            $i = 1;
            foreach ($plist as $key => $rows) 
            {   
               $tr   = array();  
               $tr[] = $rows['virtuemart_product_id'];
               $tr[] = $rows['product_sku'];
               $tr[] = $rows['product_name'];
               $tr[] = $rows['product_price'];
               $tr[] = $rows['virtuemart_category_id'];
               $tr[] = $rows['category_name'];               
               $tr[] = $rows['image_url'];
               $tr[] = $rows['image_thumb_url'];     
               $tr[] = $rows['virtuemart_media_id'];
               fputcsv($fp, $tr);
            }
            fputcsv($fp, array());
            exit;
        }
        
        public function upload()
	{
            $db = JFactory::getDbo();
            
            // Check for request forgeries
            JSession::checkToken('request') or jexit(JText::_('JINVALID_TOKEN'));
            $params = JComponentHelper::getParams('com_media');

            // Get some data from the request
            $file       = JRequest::getVar('filedata', '', 'files', 'array');               
            $return	= JRequest::getVar('return-url', null, 'post', 'base64');

             //Import filesystem libraries. Perhaps not necessary, but does not hurt
            jimport('joomla.filesystem.file');

            //Clean up filename to get rid of strange characters like spaces etc
            $filename = JFile::makeSafe($file['name']);

            if ($filename=="")
            {
                // No filename (after the name was cleaned by JFile::makeSafe)
                $this->setRedirect(base64_decode($return), JText::_('Please input a file for upload'), 'error');
                return false;
            }
            
            if ( strtolower(JFile::getExt($filename) ) != 'csv') 
            {     
                $this->setRedirect(base64_decode($return), JText::_('please upload correct file.'), 'error');
                return false;
            }    

            //Set up the source and destination of the file
            $src = $file['tmp_name'];              
            $path_vignette = "../images/stories/importfiles/";
            $dest = $path_vignette . $filename;   
            
            $siteurl = str_replace("administrator/","",JURI::base());

            if ( JFile::upload($src, $dest) ) 
            {              
                $csv_file = $path_vignette.$filename; // Name of your CSV file
                $csvfile  = fopen($csv_file, 'r');
                $theData  = fgets($csvfile);
                $i = 0;
                while (!feof($csvfile)) 
                {
                    $csv_data[] = fgets($csvfile, 1024);
                    $csv_array  = explode(",", $csv_data[$i]);
                  
                    $virtuemart_product_id = $csv_array[0];
                    $product_sku     = $csv_array[1];
                    $product_name    = $csv_array[2];
                    $product_price   = $csv_array[3];
                    $image_url       = $csv_array[6];
                    $image_url       = str_replace($siteurl,"",$image_url);                    
                    $image_thumb_url = $csv_array[7];
                    $image_thumb_url = str_replace($siteurl,"",$image_thumb_url);
                    $virtuemart_media_id = $csv_array[8];
                    
                    if(is_numeric($product_price) && $product_price!='')
                    {    
                       $prodprice = number_format($product_price, 4);
                    }else{
                       $prodprice = 0.00000;
                    }            
                    
                    // Update product name
                    $update_name = "UPDATE #__virtuemart_products_en_gb SET product_name = '$product_name' where virtuemart_product_id='$virtuemart_product_id'";
                    $db->setQuery( $update_name );
                    $db->query(); 
                    
                    // Update product code
                    $update_price = "UPDATE #__virtuemart_products SET product_sku = '$product_sku' where virtuemart_product_id='$virtuemart_product_id'";
                    $db->setQuery( $update_price );
                    $db->query(); 
                    
                    // Update product price
                    $update_price = "UPDATE #__virtuemart_product_prices SET product_price = '$prodprice' where virtuemart_product_id='$virtuemart_product_id'";
                    $db->setQuery( $update_price );
                    $db->query(); 
                    
                    // Update product image
                    $update_image1 = "UPDATE #__virtuemart_medias SET file_url='$image_url' , file_url_thumb = '$image_thumb_url' where virtuemart_media_id='$virtuemart_media_id'";
                    $db->setQuery( $update_image1 );
                    $db->query(); 
                    
                    $i++;
                }
                fclose($csvfile);

                $this->setRedirect(base64_decode($return), JText::_('File datas successfully updated to database!!'), 'success');
                
             } else {
                //Redirect and throw an error message
                //JError::raiseWarning(100, JText::_('Unable to upload file'));
                $this->setRedirect(base64_decode($return), JText::_('Unable to upload file'), 'error');
             }

            $this->setRedirect(base64_decode($return));
	}
        
}
 

            
// echo JPATH_ROOT . DS. "administrator" . DS . 'components' . DS . 'com_virtuemart' . DS . 'helpers'. DS . 'vmmodel.php'; exit;
// require_once (JPATH_ROOT . DS. "administrator" . DS . 'components' . DS . 'com_virtuemart' . DS . 'helpers'. DS . 'vmmodel.php');
//JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_virtuemart/models', 'ProductModel');

//require_once JPATH_ADMINISTRATOR . '/components/com_virtuemart/models/product.php';         
//$model = JModelLegacy::getInstance('product', 'VirtueMartModelProduct');

// JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_virtuemart/models', 'VirtueMartModel');
// $model = JModelLegacy::getInstance('Product', 'VirtueMartModel');

//           JLoader::import('joomla.application.component.model');  
//           JLoader::import( 'product', JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_virtuemart' . DS . 'models' );
//           $product_model = JModel::getInstance( 'virtumart_products', 'VirtueMartModel' );

// require_once(JPATH_ADMINISTRATOR.'/components/com_virtuemart/models/product.php');
// $product = $this->getInstance('Product', 'VirtueMartModel');

// $model = VmModel::getModel('product');

//           $myModel = $this->getModel('VirtueMartModelProduct');
//           $this->setModel($myModel);

//           jimport('joomla.application.component.model');
//           JModel::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_virtuemart'.DS.'models', 'VirtueMartModel');
//           $model = JModel::getInstance('Product', 'VirtueMartModel');