<?php
// No direct access to this file
defined('_JEXEC') or die('Restricted access');
 
/**
 * Script file of HelloWorld component
 */
class com_uamInstallerScript
{
	/**
	 * method to install the component
	 *
	 * @return void
	 */
	function install($parent) 
	{
		// $parent is the class calling this method
	}
 
	/**
	 * method to uninstall the component
	 *
	 * @return void
	 */
	function uninstall($parent) 
	{
		// $parent is the class calling this method
	}
 
	/**
	 * method to update the component
	 *
	 * @return void
	 */
	function update($parent) 
	{
		// $parent is the class calling this method
	}
 
	/**
	 * method to run before an install/update/uninstall method
	 *
	 * @return void
	 */
	function preflight($type, $parent) 
	{
		// $parent is the class calling this method
		// $type is the type of change (install, update or discover_install)
	}
 
	/**
	 * method to run after an install/update/uninstall method
	 *
	 * @return void
	 */
	function postflight($type, $parent) 
	{
		// $parent is the class calling this method
		// $type is the type of change (install, update or discover_install)

		// These are the option defaults in JSON form
		$defaults = '{';
		$defaults .= '"iconset":"17",';
		$defaults .= '"new_article_button":"1",';
		$defaults .= '"new_article_button_custom":"0",';
		$defaults .= '"new_article_button_text":"New article",';
		$defaults .= '"link_new_article_default":"1",';
		$defaults .= '"link_new_article":"",';
		$defaults .= '"copy_uses_todays_date":"0",';
		$defaults .= '"copy_uses_current_user":"0",';
		$defaults .= '"showsearchfilter":"1",';
		$defaults .= '"showcategoryfilter":"1",';
		$defaults .= '"showauthorfilter":"1",';
		$defaults .= '"showpublishedstatefilter":"1",';
		$defaults .= '"showlanguagefilter":"0",';
		$defaults .= '"id_column":"1",';
		$defaults .= '"title_column":"1",';
		$defaults .= '"title_link":"1",';
		$defaults .= '"show_content":"0",';
		$defaults .= '"published_column":"1",';
		$defaults .= '"featured_column":"0",';
		$defaults .= '"category_column":"1",';
		$defaults .= '"author_column":"1",';
		$defaults .= '"show_alias":"1",';
		$defaults .= '"language_column":"0",';
		$defaults .= '"created_date_column":"1",';
		$defaults .= '"start_publishing_column":"0",';
		$defaults .= '"finish_publishing_column":"0",';
		$defaults .= '"hits_column":"1",';
		$defaults .= '"edit_alias_column":"0",';
		$defaults .= '"copy_column":"0",';
		$defaults .= '"edit_column":"1",';
		$defaults .= '"trash_column":"1",';
		$defaults .= '"user_can_publish":"0",';
		$defaults .= '"user_can_feature":"0",';
		$defaults .= '"user_can_trash":"0",';
		$defaults .= '"user_can_view":"0"';
		$defaults .= '}';

		if ($type == 'install') {
			$db = &JFactory::getDBO();
			$query	= $db->getQuery(true);
			$query->update('#__extensions');
			$query->set("params = " . "'".$defaults."'");
			$query->where("name = 'com_uam'");
			$db->setQuery($query);
			$db->query();
		}
		else if ($type == 'update') {
			$db = &JFactory::getDBO();
			$query	= $db->getQuery(true);

			$query->select('params');
			$query->from('#__extensions');
			$query->where("name = 'com_uam'");
			$db->setQuery($query);
			$saved = $db->loadAssoc();
			$old = json_decode($saved['params'], true);
			$new = json_decode($defaults, true);

			// If options already exist, keep the old ones.
			if ($old) {
				$new = array_merge($new, $old);
				$options = json_encode($new);
			}
			else {
				$options = $defaults;
			}

			$query->update('#__extensions');
			$query->set("params = " . "'".$options."'");
			$query->where("name = 'com_uam'");
			$db->setQuery($query);
			$db->query();



		}
	}
}