<?php
/**
 * K2 Item export class
 *
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2013 RolandD Cyber Produksi. All rights reserved.
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: customfieldsexport.php 1924 2012-03-02 11:32:38Z RolandD $
 */

defined('_JEXEC') or die;

/**
 * Processor for Joomla Item exports
 */
class CsviModelItemExport extends CsviModelExportfile {

	/**
	 * Start the export
	 *
	 * @copyright
	 * @author		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return 		void
	 * @since 		3.4
	 */
	public function getStart() {
		// Get some basic data
		$db = JFactory::getDbo();
		$csvidb = new CsviDb();
		$jinput = JFactory::getApplication()->input;
		$csvilog = $jinput->get('csvilog', null, null);
		$template = $jinput->get('template', null, null);
		$exportclass =  $jinput->get('export.class', null, null);
		$export_fields = $jinput->get('export.fields', array(), 'array');
		$this->_domainname = CsviHelper::getDomainName();
		$helper = new Com_K2();
		$sef = new CsviSef();

		// Build something fancy to only get the fieldnames the user wants
		$userfields = array();
		foreach ($export_fields as $column_id => $field) {
			switch ($field->field_name) {
				case 'category_path':
					$userfields[] = $db->qn('i').'.'.$db->qn('catid');
					break;
				case 'image':
				case 'image_url':
				case 'image_url_thumb':
					$userfields[] = "MD5(CONCAT('Image', ".$db->qn('id').")) AS ".$db->qn('image');
					break;
				case 'item_url':
					$userfields[] = $db->qn('i.id');
					break;
				case 'custom':
					break;
				default:
					$userfields[] = $db->qn($field->field_name);
					break;
			}
		}

		// Build the query
		$userfields = array_unique($userfields);
		$query = $db->getQuery(true);
		$query->select(implode(",\n", $userfields));
		$query->from($db->qn("#__k2_items", "i"));

		$selectors = array();

		// Filter by published state
		$publish_state = $template->get('publish_state', 'general');
		if ($publish_state != '' && ($publish_state == 1 || $publish_state == 0)) {
			$selectors[] = $db->qn('i.published').' = '.$publish_state;
		}

		// Filter by language
		$language = $template->get('item_language', 'general');
		if ($language != '*') {
			$selectors[] = $db->qn('i.language').' = '.$db->q($language);
		}

		// Filter by category
		$categories = $template->get('item_categories', 'item');
		if ($categories && $categories[0] != '') {
			$selectors[] = $db->qn('catid')." IN ('".implode("','", $categories)."')";
		}

		// Check if we need to attach any selectors to the query
		if (count($selectors) > 0 ) $query->where(implode("\n AND ", $selectors));

		// Ingore fields
		$ignore = array('custom', 'category_path', 'image', 'item_url', 'image_url', 'image_url_thumb');

		// Check if we need to group the orders together
		$groupby = $template->get('groupby', 'general', false, 'bool');
		if ($groupby) {
			$filter = $this->getFilterBy('groupby', $ignore);
			if (!empty($filter)) $query->group($filter);
		}

		// Order by set field
		$orderby = $this->getFilterBy('sort', $ignore);
		if (!empty($orderby)) $query->order($orderby);

		// Add a limit if user wants us to
		$limits = $this->getExportLimit();

		// Execute the query
		$csvidb->setQuery($query, $limits['offset'], $limits['limit']);
		$csvilog->addDebug(JText::_('COM_CSVI_EXPORT_QUERY'), true);

		// There are no records, write SQL query to log
		if (!is_null($csvidb->getErrorMsg())) {
			$this->addExportContent(JText::sprintf('COM_CSVI_ERROR_RETRIEVING_DATA', $csvidb->getErrorMsg()));
			$this->writeOutput();
			$csvilog->AddStats('incorrect', $csvidb->getErrorMsg());
		}
		else {
			$logcount = $csvidb->getNumRows();
			$jinput->set('logcount', $logcount);
			if ($logcount > 0) {
				while ($record = $csvidb->getRow()) {
					if ($template->get('export_file', 'general') == 'xml' || $template->get('export_file', 'general') == 'html') $this->addExportContent($exportclass->NodeStart());
					foreach ($export_fields as $column_id => $field) {
						$fieldname = $field->field_name;
						$fieldreplace = $field->field_name.$field->column_header;
						// Add the replacement
						if (isset($record->$fieldname)) $fieldvalue = CsviHelper::replaceValue($field->replace, $record->$fieldname);
						else $fieldvalue = '';
						switch ($fieldname) {
							case 'category_path':
								$category_path = trim($helper->createCategoryPathById($record->catid));
								if (strlen(trim($category_path)) == 0) $category_path = $field->default_value;
								$category_path = CsviHelper::replaceValue($field->replace, $category_path);
								$record->output[$column_id] = $category_path;
								break;
							case 'item_url':
								// Let's create a SEF URL
								$_SERVER['QUERY_STRING'] = 'option=com_k2&view=item&id='.$record->id;
								$item_url = $sef->getSiteRoute('index.php?'.$_SERVER['QUERY_STRING']);

								$item_url = CsviHelper::replaceValue($field->replace, $item_url);
								$record->output[$column_id] = $item_url;
								break;
							case 'image':
								// Check if there is already a product full image
								$image = $record->image.'.jpg';
								if (empty($image)) $image = $field->default_value;
								$image = CsviHelper::replaceValue($field->replace, $image);
								$record->output[$column_id] = $image;
								break;
							case 'image_url':
								// Check if there is already a product full image
								$picture_url = $this->_domainname.'/media/k2/items/cache/'.$record->image.'_'.$template->get('image_url', 'item', 'Generic').'.jpg';
								if (empty($picture_url)) $picture_url = $field->default_value;
								$picture_url = CsviHelper::replaceValue($field->replace, $picture_url);
								$record->output[$column_id] = $picture_url;
								break;
							case 'image_url_thumb':
								// Check if there is already a product full image
								$picture_url = $this->_domainname.'/media/k2/items/cache/'.$record->image.'_'.$template->get('image_url_thumb', 'item', 'S').'.jpg';
								if (empty($picture_url)) $picture_url = $field->default_value;
								$picture_url = CsviHelper::replaceValue($field->replace, $picture_url);
								$record->output[$column_id] = $picture_url;
								break;
							case 'custom':
								if (strlen(trim($fieldvalue)) == 0) $fieldvalue = $field->default_value;
								$fieldvalue = CsviHelper::replaceValue($field->replace, $fieldvalue);
								$record->output[$column_id] = $fieldvalue;
								break;
							default:
								// Check if we have any content otherwise use the default value
								if (strlen(trim($fieldvalue)) == 0) $fieldvalue = $field->default_value;
								$record->output[$column_id] = $fieldvalue;
								break;
						}
					}
					// Output the data
					$this->addExportFields($record);

					if ($template->get('export_file', 'general') == 'xml' || $template->get('export_file', 'general') == 'html') {
						$this->addExportContent($exportclass->NodeEnd());
					}

					// Output the contents
					$this->writeOutput();
				}
			}
			else {
				$this->addExportContent(JText::_('COM_CSVI_NO_DATA_FOUND'));
				// Output the contents
				$this->writeOutput();
			}
		}
	}
}