<?php
/**------------------------------------------------------------------------
com_articleman -  Article Factory Manager 3.1.6
------------------------------------------------------------------------
 * @author TheFactory
 * @copyright Copyright (C) 2012 SKEPSIS Consult SRL. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: http://www.thefactory.ro
 * Technical Support: Forum - http://www.thefactory.ro/joomla-forum/
-------------------------------------------------------------------------*/

define("VERSION_ROOT",'http://thefactory.ro/versions/');

class component_version_info {
	var $latestversion=null;
	var $downloadlink=null;
	var $newsletter=null;
	var $announcements=null;
	var $releasenotes=null;
	var $_componentname=null;

	function component_version_info( $componentname ) {
		$this->_componentname=$componentname;
		$this->GetInfo();
	}
    function remote_read_url( $uri ) {

        if ( function_exists('curl_init') ){
            $handle = curl_init();

            curl_setopt ($handle, CURLOPT_URL, $uri);
            curl_setopt ($handle, CURLOPT_MAXREDIRS,5);
            curl_setopt ($handle, CURLOPT_AUTOREFERER, 1);
            curl_setopt ($handle, CURLOPT_FOLLOWLOCATION ,1);
            curl_setopt ($handle, CURLOPT_CONNECTTIMEOUT, 10);
            curl_setopt ($handle, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt ($handle, CURLOPT_TIMEOUT, 10);

            $buffer = @curl_exec($handle);

            curl_close($handle);
            return $buffer;
        } else  if ( ini_get('allow_url_fopen') ) {
            $fp = @fopen( $uri, 'r' );
            if ( !$fp )
                return false;
         	stream_set_timeout($fp, 20);
            $linea = '';
            while( $remote_read = fread($fp, 4096) )
                $linea .= $remote_read;
       		$info = stream_get_meta_data($fp);
            fclose($fp);
        	if ($info['timed_out'])
        	   return false;
            return $linea;
        } else {
           return false;
        }
    }
	function GetInfo()
	{
		jimport('joomla.utilities.simplexml');

		$filename=VERSION_ROOT.$this->_componentname.".xml";
		$fileContents =@$this->remote_read_url($filename);
		//vardump($fileContents,1);

		$xmlparser = new JSimpleXML;

		if (!$xmlparser->loadString(trim($fileContents)) )
		{
			return false;
		}
		$xmldoc = $xmlparser->document;

		$element = $xmldoc->getElementByPath('/latestversion');
		$this->latestversion = $element ? $element->data() : '';		
		$element= $xmldoc->getElementByPath('/downloadlink');
		$this->downloadlink =$element ? $element->data() : '';
		$element= $xmldoc->getElementByPath('/newdownloadlink');
		$this->newdownloadlink =$element ? $element->data() : '';
		$element= $xmldoc->getElementByPath('/newsletter');
		$this->newsletter = $element ? $element->data() : '';
		$element = $xmldoc->getElementByPath('/announcements');
		$this->announcements = $element ? $element->data() : '';
		$element = $xmldoc->getElementByPath('/notes');
		$this->releasenotes = $element ? $element->data() : '';

		return true;
	}
}
?>