<?php
/**------------------------------------------------------------------------
com_articleman -  Article Factory Manager 3.1.6
------------------------------------------------------------------------
 * @author TheFactory
 * @copyright Copyright (C) 2012 SKEPSIS Consult SRL. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: http://www.thefactory.ro
 * Technical Support: Forum - http://www.thefactory.ro/joomla-forum/
-------------------------------------------------------------------------*/

defined( '_JEXEC' ) or die( 'Restricted access' );

if(!class_exists('xajax'))
{
	$oe = error_reporting();
	error_reporting(0);
	require(JPATH_COMPONENT_ADMINISTRATOR.DS.'xajax'.DS.'xajax_core'.DS.'xajaxAIO.inc.php');
	error_reporting($oe);
}

class JTheFactoryXajax{
	
	var $xajax=null;
	var $xajaxMethods=null;
	
	function __construct(&$aCallableObjects,&$aFunctionNames,$jsInHead=true){
		global $option;
        $option = 'com_articleman';

		$requestURI = JURI::base().'index.php?option='.$option.'&jaxx=1';

		$xajax = new xajax($requestURI);

		$xajax->setWrapperPrefix('theFactory_');
		
		$xajaxMethods = array();
		foreach($aCallableObjects as $k=>$cO)
		{
			$xajaxMethods = array_merge($xajaxMethods, $xajax->register(XAJAX_CALLABLE_OBJECT,$aCallableObjects[$k]) );
		}
		foreach($aFunctionNames as $fN)
		{
			$xajaxMethods = array_merge($xajaxMethods, $xajax->register(XAJAX_FUNCTION,$fN));
		}

		foreach($xajaxMethods as $k=>$v)
		{
			$xm =& $xajaxMethods[$k];
			$xm->useSingleQuote();
		}

		$jsURI = JURI::root().'administrator/components/'.$option.'/xajax/';

		if($jsInHead){

            //$xajax->configure("javascript URI",$jsURI);
            $js = preg_replace('#((\A\s*<script\s.*?>)|(</script>\s*\Z))#','',$xajax->getJavascript($jsURI)) ;
			$document =& JFactory::getDocument();
			$document->addScriptDeclaration($js);
		}
		else{
			//$xajax->printJavascript($jsURI);
            $xajax->configure("javascript URI",$jsURI);
		}

		$this->xajax =& $xajax;
		$this->xajaxMethods =& $xajaxMethods;

		foreach($aCallableObjects as $k=>$cO){
			//the callable object needs to "know" his registered xajax callbacks, so it can eventually generate scripts to be sent to client
			//in this component,a good example is in admin.articleman.xajax.php function, in "listCategories" method, where we need to send back the js call to the "deleteRestriction" method
			$aCallableObjects[$k]->xajaxMethods = $xajaxMethods;
		}
	}
	
	function &getXajaxInstance(){
		return $this->xajax;
	}
	function &getXajaxMethods(){
		return $this->xajaxMethods;
	}
}
?>