<?php
/**------------------------------------------------------------------------
com_articleman -  Article Factory Manager 3.1.6
------------------------------------------------------------------------
 * @author TheFactory
 * @copyright Copyright (C) 2012 SKEPSIS Consult SRL. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: http://www.thefactory.ro
 * Technical Support: Forum - http://www.thefactory.ro/joomla-forum/
-------------------------------------------------------------------------*/

defined('_JEXEC') or die('Restricted access!');

class JTableArtXRef extends JTable {

    var $articleid = null;
    //pending,normal,rejected,draft
    var $state = null;
    var $reason = null;
    var $approver_id = null;

    function __construct(&$db) {
        parent::__construct('#__art_articles_ref','articleid',$db);
    }

    function store() {
        $axr = JTable::getInstance('artxref');
        if($this->articleid && $axr->load($this->articleid)) {
            return parent::store();
        }
        return $this->_db->insertObject($this->getTableName(),$this);
    }

    function triggerMails(&$row,$oldstate,$state) {

		if(!isset($oldstate)){
			switch ($state){
				case "pending":
		        	if (_ART_SET_pendingAuthor=='1') {
		            	articleman_ancestor::sendMail($row,'pendingAuthor');
		            }
		        	if (_ART_SET_pendingAdmin=='1') {
		            	articleman_ancestor::sendMail($row,'pendingAdmin',1);
		        	}
				break;
				case "normal":
		        	if (_ART_SET_acceptAuthorEmail=='1') {
		            	articleman_ancestor::sendMail($row,'publish');
		            }
				break;
			}
		}
		elseif('normal'==$oldstate)
		{
        	if(_ART_SET_ticketpreapproval) {
				if (_ART_SET_pendingAuthor=='1') {
	            	articleman_ancestor::sendMail($row,'pendingAuthor');
	            }
 			} else {
 				//articleman_ancestor::sendMail($row,'publish');
 			}
        	if (_ART_SET_pendingAdmin=='1') {
            	articleman_ancestor::sendMail($row,'pendingAdmin',1);
        	}
		}
	}
}