<?php
/**------------------------------------------------------------------------
com_articleman -  Article Factory Manager 3.1.6
------------------------------------------------------------------------
 * @author TheFactory
 * @copyright Copyright (C) 2012 SKEPSIS Consult SRL. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: http://www.thefactory.ro
 * Technical Support: Forum - http://www.thefactory.ro/joomla-forum/
-------------------------------------------------------------------------*/

defined('_JEXEC') or die('Restricted access!');

class JTableArtRevision extends JTable {

    var $contentId = 0;

	function __construct(&$db) {
		parent::__construct('#__art_revisions','id',$db);
	}

    //some kind of ancLoad() :P
    function loadByContentId($contentId) {

        $article = JTable::getInstance('content');

        $rev = $this->getLastRevision($contentId);
        if($rev) {
            $article->bind( JArrayHelper::fromObject($rev) );
            //this is very important!
            $article->id = $rev->contentId;    
        }

        return $article;
    }

    
    function store($row,$state) {

        $res = false;

        $this->contentId = $row->id;

        $lastRevision = $this->getLastRevision();
        
        switch($state) {

            case 'pending':
            case 'draft':

                if(is_null($lastRevision)) {
                    //first save in content table, so we get a content id
                    $row->store();

                    //then save in the revision table
                    $this->bind($row);
                    $this->id = null;
                    $this->contentId = $row->id;
                    $step1 = parent::store();

                    //delete the content record (AUTO_INCREMENT value is not affected by this)
                    $step2 = $row->delete();

                    $res = $step1 && $step2;
                } else {
                    $this->bind($row);
                    if('revision'==$lastRevision->src) {
                        //this means the article is still pending, so we overwrite the old revision
                        $this->id = $lastRevision->id;
                        //UGLY (but necessary) HACK; if the article is only in "revisions" table, it loses "created_by" value
                        $this->created_by = $lastRevision->created_by;
                    } elseif ('content'==$lastRevision->src) {
                        $this->id = null;
                    }
                    $this->contentId = $lastRevision->contentId;

                    $res = parent::store();
                }
                break;

            case 'normal':

                if(is_null($lastRevision)) {
                    //when a publisher sends an article first time, there is no previous revision, so a simple article store is enough
                    $res = $row->store();
                    $this->contentId = $row->id;
                } else {
                    //the article has previous revisions in db
                    if('revision'==$lastRevision->src) {
                        //search for an existing article with this content id
                        $article = JTable::getInstance('content');
                        if($article->load($lastRevision->contentId)) {
                            //if found, save that article as a new revision
                            $this->bind($article);
                            $this->id = null;
                            $this->contentId = $lastRevision->contentId;
                            $step1 = parent::store();

                            //replace the article with the current (submitted) row
                            $row->id = $lastRevision->contentId;
                            $step2 = $row->store();

                            $res = $step1 && $step2;
                        } else {
                            //if not found, create (INSERT) a new article with that specific content id
                            $row->id = $lastRevision->contentId;
                            //UGLY (but necessary) HACK; if the article is only in "revisions" table, it loses "created_by" value
                            $row->created_by = $lastRevision->created_by;
                            $res = $this->_db->insertObject($row->getTableName(),$row,'id');

                            //remove the current revision
                            $this->delete($lastRevision->id);
                        }
                    } elseif('content'==$lastRevision->src) {
                        //old article becomes a revision
                        $oldContent = JTable::getInstance('content');
                        $oldContent->load($lastRevision->contentId);

                        $this->bind($oldContent);
                        $this->id = null;
                        $this->contentId = $lastRevision->contentId;
                        $step1 = parent::store();
                        
                        //new submitted row becomes an article
                        $step2 = $row->store();
                        $res = $step1 && $step2;
                    }
                }
                break;

                case 'reject':
                    if(is_null($lastRevision)) {
                        //when a publisher sends an article first time, there is no previous revision, so a simple article store is enough
                        $res = $row->store();
                        $this->contentId = $row->id;
                    } else {
                        //the article has previous revisions in db
                        $this->bind($row);
                        if('revision'==$lastRevision->src) {
                            //this means the article is still pending, so we overwrite the old revision
                            $this->id = $lastRevision->id;
                            //UGLY (but necessary) HACK; if the article is only in "revisions" table, it loses "created_by" value
                            $this->created_by = $lastRevision->created_by;
                        } elseif ('content'==$lastRevision->src) {
                            $this->id = null;
                        }
                        $this->contentId = $lastRevision->contentId;

                        $res = parent::store();
                    }
                    break;
        }

        //delete old stored revisions
        if(constant('_ART_SET_nr_revisions_saved')) {
            $this->deleteOldestRevisions(_ART_SET_nr_revisions_saved);
        }

        //this seems fishy, but is needed
        $row->id = $this->contentId;

        return $res;
    }

    function deleteOldestRevisions($nrRevisions) {

        $this->_db->setQuery('SELECT id FROM #__art_revisions WHERE contentId=\''.$this->_db->getEscaped($this->contentId).'\' ORDER BY `modified` DESC');
        $ids = $this->_db->loadResultArray();

        if( count($ids) > $nrRevisions) {
            $removeIds = array_slice($ids,$nrRevisions);
            $this->_db->setQuery('DELETE FROM #__art_revisions WHERE id IN ('.implode(',',$removeIds).')');
            $this->_db->query();
        }

        return $this->_db->loadObject();
    }

    function getLastRevision($contentId=0) {

        $contentId = $contentId ? $contentId : $this->contentId;

        $this->_db->setQuery('(SELECT *, \'revision\' AS src FROM #__art_revisions WHERE contentId=\''.$this->_db->getEscaped($contentId).'\' ORDER BY modified DESC LIMIT 1)
            UNION
        (SELECT *, id as contentId, \'content\' AS src FROM #__content WHERE id=\''.$this->_db->getEscaped($contentId).'\') ORDER BY modified DESC LIMIT 1');

        return $this->_db->loadObject();
    }

    function changeStateRevisionId($contentId=0,$changedState) {

        $database = JFactory::getDBO();
        $contentId = $contentId ? $contentId : $this->contentId;

        $database->setQuery('UPDATE #__art_revisions SET state=\''.$database->escape($changedState).'\' WHERE contentId=\''.$database->escape($contentId).'\' ');
        if (!$database->query())
            return false;

        return true;
    }
}
?>