<?php
/**------------------------------------------------------------------------
com_articleman -  Article Factory Manager 3.1.6
------------------------------------------------------------------------
 * @author TheFactory
 * @copyright Copyright (C) 2012 SKEPSIS Consult SRL. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: http://www.thefactory.ro
 * Technical Support: Forum - http://www.thefactory.ro/joomla-forum/
-------------------------------------------------------------------------*/

defined('_JEXEC') or die();

class com_articlemanInstallerScript
{
	private $alreadyInstalled=false;

	function postflight() {
		jimport('joomla.filesystem.file');

		$basePath = JPATH_ROOT.DS.'components'.DS.'com_articleman'.DS.'config';
		$configFile = $basePath.DS.'config.php';
		$defaultConfigFile = 'config.default.php';
		$restrictionsFile = $basePath.DS.'restrictions.php';
		$defaultRestrictionsFile = 'restrictions.default.php';

		if(JFile::exists($configFile) || JFile::exists($restrictionsFile)){
			JFile::delete($basePath.DS.$defaultConfigFile);
			JFile::delete($basePath.DS.$defaultRestrictionsFile);
		} else {
			JFile::move($defaultConfigFile,$configFile,$basePath);
			JFile::move($defaultRestrictionsFile,$restrictionsFile,$basePath);
		}

		return true;
	}
	function install()
	{
		if($this->alreadyInstalled) {
			
			return true;
		}

		jimport('joomla.filesystem.file');
		$database = &JFactory::getDBO();
		
		$qry = "INSERT INTO `#__art_articles_ref` (`articleid`,`state`) SELECT `id`,'normal' AS `state` FROM `#__content`";
		$database->setQuery($qry);
		$database->query();
		if (JFile::exists(JPATH_ROOT . DS . '/administrator/components/com_joomfish/joomfish.xml') || JFile::exists(JPATH_ROOT . DS . '/administrator/components/com_joomfish/joomfish.php'))
		{
			$src = JPATH_ROOT . DS .'components'.DS.'com_articleman'.DS.'celements'.DS.'art_emailtmpl.xml';
			$dst = JPATH_ROOT . DS .'administrator'.DS.'components'.DS.'com_joomfish'.DS.'contentelements'.DS.'art_emailtmpl.xml';
			JFile::move( $src, $dst);
		}

		if($this->articleman_cb_detect())
		{
			$this->installCBPlugin('Article Manager Factory - My Articles','My articles','articleman_my_articles','plug_articleman_my_articles','getmyarticlesTab');
		}

		JLoader::register('component_version_info',JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_articleman' . DS . 'version_info.php');
		$version = new component_version_info('com_articleman');
?>
	<table class="adminform">
		<tr>
			<td><?php $this->printfile("install.notes");?></td>
		</tr>
		<tr>
			<td>
			<p>
			Thank you for purchasing <strong>Article Manager</strong>.<br>

			Please set up your <strong>Article Manager</strong> in the <a href='<?php echo JURI::root();?>administrator/index.php?option=com_articleman&task=config'>admin panel</a></p>
			<br>
			<br>
			<p> Release Notes:<br>
			 <br>
			<?php echo $version->releasenotes;?>
			</p>
			<p><strong>Article Manager </strong> Component <em>for Joomla CMS</em> <br />
			Visit us at <a target="_blank" href="http://www.thefactory.ro">thefactory.ro</a> to learn  about new versions
			and/or to give us feedback<br>
			(c) 2006-2012 thefactory.ro
			</td>
		</tr>
	</table>
<?php 
	}

	function uninstall()
	{
		?>
			<strong>Thank you for using Articlemanager</strong><br/>
			For more information about Articlemanager visit our Homepage <a href="http://www.thefactory.ro" target="_blank">The Factory</a>
		<?php
	}

	function printfile($filename)
	{
		$filename=JPATH_ROOT . DS . "administrator" . DS . "components" . DS . "com_articleman" . DS . "$filename";
		if (!file_exists($filename)) return;
		readfile($filename);
	}


	function installCBPlugin($plugintitle,$tabtitle,$pluginname,$folder,$class)
	{
		$database = & JFactory::getDBO();

		$query = "INSERT INTO #__comprofiler_plugin set
			`name`='$plugintitle',
			`element`='$pluginname.plugin',
			`type`='user',
			`folder`='$folder',
			`ordering`=99,
			`published`=1,
			`iscore`=0
		";
		$database->setQuery( $query );
		$database->query();

		$plugid=$database->insertid();
		$query = "INSERT INTO #__comprofiler_tabs set
			`title`='$tabtitle',
			`ordering`=999,
			`enabled`=1,
			`pluginclass`='$class',
			`pluginid`='$plugid',
			`fields`=0,
			`displaytype`='tab',
			`position`='cb_tabmain'
		";
		$database->setQuery( $query );
		$database->query();

		@mkdir(JPATH_ROOT . DS.'components'.DS.'com_comprofiler'.DS.'plugin'.DS.'user'.DS.$folder);
		
		$source_file = JPATH_ROOT . DS . "administrator" .DS."components".DS."com_articleman".DS."cb_plugins".DS."$pluginname.plugin.php";
		$destination_file = JPATH_ROOT . DS."components".DS."com_comprofiler".DS."plugin".DS."user".DS.$folder.DS."$pluginname.plugin.php";
		copy ($source_file, $destination_file);

		$source_file = JPATH_ROOT . DS . "administrator" .DS."components".DS."com_articleman".DS."cb_plugins".DS."$pluginname.plugin.xml";
		$destination_file = JPATH_ROOT .DS."components".DS."com_comprofiler".DS."plugin".DS."user".DS.$folder.DS."$pluginname.plugin.xml";
		copy ($source_file, $destination_file);

	}

	function Articleman_cb_detect(){
		$database = &JFactory::getDBO();
		$database->setQuery("SELECT * FROM `#__extensions` WHERE `type`='component' AND `element`='com_comprofiler'");
		$comprofiler = $database->loadResult();
		if(count($comprofiler)<=0){
			return false;
		}
		return true;
	}
}
?>