CREATE TABLE IF NOT EXISTS`#__art_articles_attachments` (
	`id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
	`contentId` INT(11) UNSIGNED NOT NULL DEFAULT '0',
	`attachmentName` VARCHAR(255) NOT NULL DEFAULT '0',
	`attachmentExtension` VARCHAR(10) NOT NULL DEFAULT '0',
	`cloackName` VARCHAR(50) NOT NULL DEFAULT '0',
	PRIMARY KEY (`id`),
	INDEX `contentId` (`contentId`),
	INDEX `cloackName` (`cloackName`)
);

CREATE TABLE IF NOT EXISTS `#__art_articles_ref` (
  `articleid` int(11) NOT NULL default '0',
  `state` enum('pending','normal','rejected', 'draft') default 'pending',
  `reason` text,approver_id int(11),
PRIMARY KEY  (`articleid`)
);

CREATE TABLE IF NOT EXISTS `#__art_emailtmpl` (
  `id` int(11) NOT NULL auto_increment,
  `type` varchar(30) default NULL,
  `subject` varchar(200) default NULL,
  `template` text,
  PRIMARY KEY  (`id`),
  KEY `title` (`type`)
);

CREATE TABLE IF NOT EXISTS `#__art_reason` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(80) default NULL,
  `reason` text,
  `toolbar` tinyint(1) default 1,
  PRIMARY KEY  (`Id`)
);

CREATE TABLE IF NOT EXISTS `#__art_resourcebox` (
  `Id` int(11) NOT NULL auto_increment,
  `authorId` int(11) default NULL,
  `text` text,
  `file` varchar(255),
  `file_params` text,
  PRIMARY KEY  (`Id`),
  KEY `authorId` (`authorId`)
);

CREATE TABLE IF NOT EXISTS`#__art_cbfields` (
  `id` int(11) NOT NULL auto_increment,
  `field` varchar(255) NOT NULL,
  `cb_field` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
);

CREATE TABLE `#__art_revisions` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`asset_id` INT(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
	`title` VARCHAR(255) NOT NULL DEFAULT '',
	`alias` VARCHAR(255) NOT NULL DEFAULT '',
	`title_alias` VARCHAR(255) NOT NULL DEFAULT '',
	`introtext` MEDIUMTEXT NOT NULL,
	`fulltext` MEDIUMTEXT NOT NULL,
	`state` TINYINT(3) NOT NULL DEFAULT '0',
	`sectionid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`mask` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`catid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`created` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`created_by` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`created_by_alias` VARCHAR(255) NOT NULL DEFAULT '',
	`modified` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`modified_by` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`checked_out` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`publish_up` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`publish_down` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`images` TEXT NOT NULL,
	`urls` TEXT NOT NULL,
	`attribs` VARCHAR(5120) NOT NULL,
	`version` INT(10) UNSIGNED NOT NULL DEFAULT '1',
	`parentid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`ordering` INT(11) NOT NULL DEFAULT '0',
	`metakey` TEXT NOT NULL,
	`metadesc` TEXT NOT NULL,
	`access` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`hits` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`metadata` TEXT NOT NULL,
	`featured` TINYINT(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
	`language` CHAR(7) NOT NULL COMMENT 'The language code for the article.',
	`xreference` VARCHAR(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
	`contentId` INT(10) NOT NULL DEFAULT '-1',
	PRIMARY KEY (`id`),
	INDEX `idx_access` (`access`),
	INDEX `idx_checkout` (`checked_out`),
	INDEX `idx_state` (`state`),
	INDEX `idx_catid` (`catid`),
	INDEX `idx_createdby` (`created_by`),
	INDEX `idx_featured_catid` (`featured`, `catid`),
	INDEX `idx_language` (`language`),
	INDEX `idx_xreference` (`xreference`),
	INDEX `contentId` (`contentId`),
	INDEX `modified` (`modified`)
)
COLLATE='utf8_general_ci';

INSERT INTO `#__art_cbfields` (`id`, `field`, `cb_field`) VALUES (1, 'text', ''),(2, 'avatar', ''),(3, 'file_params', '');
INSERT INTO `#__art_emailtmpl` (`id`,`type`,`subject`,`template`) VALUES (1,'reject','Your Article was not approved!','Sorry %name%, \r\nYour Article \"%title%\", submitted on %date% was rejected.\r\nYou can still publish it by fixing the following problems:\r\n%reason%\r\n\r\nLog in as %username% on our site and edit your article');
INSERT INTO `#__art_emailtmpl` (`id`,`type`,`subject`,`template`) VALUES (2,'publish','Your Article %title% was published','Hello %name%,\r\nYour Article \"%title%\", submitted on %date% was just approved. You can see your article here:\r\n%url%');
INSERT INTO `#__art_emailtmpl` (`id`,`type`,`subject`,`template`) VALUES (3,'pendingAuthor','Your Article %title% is pending approval','Hello %name%, \r\nYour Article \"%title%\", submitted on %date% is pending approval.\r\nDepending on our workload the article will be processed in few hours.');
INSERT INTO `#__art_emailtmpl` (`id`,`type`,`subject`,`template`) VALUES (4,'pendingAdmin','A new Article was submitted by %username%','Today - %date% a new article was submitted with the title:\r\n%title%\r\n\r\nand it is waiting your approval');
INSERT INTO `#__art_emailtmpl` (`id`,`type`,`subject`,`template`) VALUES (5,'unpublish','Your Article %title% was unpublished','Dear %name%, \r\nYour Article \"%title%\", submitted on %date% was unpublished.\r\nYou can still republish it by logging in as %username% on our site and edit your article');
INSERT INTO `#__art_emailtmpl` (`id`,`type`,`subject`,`template`) VALUES (6,'publish_w_msg','Your Article %title% was published','<p>Hello %name%,</p>
<p>Your Article "%title%", submitted on %date% was just approved.</p><p>You can see your article here: %url%</p><p>%message%</p>');

INSERT INTO `#__art_reason` (`id`,`title`,`reason`) VALUES (3,'Not the right Category','The category you posted your article is not the right one\r\nChange it according to the content of your article\r\n');
INSERT INTO `#__art_reason` (`id`,`title`,`reason`) VALUES (4,'Duplicate content','Your article already exists in our site');