<?php
/**------------------------------------------------------------------------
com_articleman -  Article Factory Manager 3.1.6
------------------------------------------------------------------------
 * @author TheFactory
 * @copyright Copyright (C) 2012 SKEPSIS Consult SRL. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: http://www.thefactory.ro
 * Technical Support: Forum - http://www.thefactory.ro/joomla-forum/
-------------------------------------------------------------------------*/

defined( '_JEXEC' ) or die( 'Restricted access' );
require_once(JPATH_SITE . DS . 'components' . DS . 'com_articleman' . DS . 'class' . DS . 'mainclass.php');

class articleman_admin extends articleman_ancestor
{
	function __construct()
	{
		JLoader::register('HTML_adminArticleman',JPATH_COMPONENT_ADMINISTRATOR.DS.'admin.articleman.html.php');
        JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
	}

	function listArticles()
	{
		$where = array();
		$database = &JFactory::getDBO();
		$jconfig = new JConfig;
		$list_limit = $jconfig->list_limit;
		
		if(!isset($_SESSION)) session_start();

        $limitstart= JArrayHelper::getValue($_SESSION,"limitstart",0);
		$limit = JArrayHelper::getValue($_SESSION,"limit",$list_limit);

        $searchString = JArrayHelper::getValue($_SESSION,"searchstring","");

		$filter_catid= JArrayHelper::getValue($_SESSION,"filter_catid",0);

		$filter_state= JArrayHelper::getValue($_SESSION,"filter_state",1);

		$filter_order= JArrayHelper::getValue($_SESSION,"filter_order",'');
		$filter_order_Dir= JArrayHelper::getValue($_SESSION,"filter_order_Dir",'');

		$limitstart= JRequest::getVar("limitstart",$limitstart);$limit = JRequest::getVar("limit",$limit);
        $searchString = JRequest::getVar("searchstring",$searchString);
		$filter_catid= JRequest::getVar("filter_catid",$filter_catid);
		$filter_state= JRequest::getVar("filter_state",$filter_state);
		$filter_order= JRequest::getVar("filter_order",$filter_order);$filter_order_Dir= JRequest::getVar("filter_order_Dir",$filter_order_Dir);

		$_SESSION["limitstart"]=$limitstart;$_SESSION["limit"]=$limit;
		$_SESSION["searchstring"]=$searchString;
		$_SESSION["filter_catid"]=$filter_catid;
		$_SESSION["filter_state"]=$filter_state;
		$_SESSION["filter_order"]=$filter_order;$_SESSION["filter_order_Dir"]=$filter_order_Dir;

		//$where[] = "b.state <> 'draft'";
        $having = array();
        $where=array();
		if ($searchString)
		{
			$searchTerm = $database->getEscaped($searchString);
			$where[]= " (a.title like '%$searchTerm%' or a.introtext like '%$searchTerm%' or a.fulltext like '%$searchTerm%')";
		}
    	if($filter_catid)
    	{
            $where[]= "a.catid='".(int)$filter_catid."'";
		}
		switch ($filter_state)
		{
			case 1://pending
				$where[]= "a.state=0 and b.state='pending'";
				break;
			case 2://published
				$where[]= "a.state=1";
				break;
			case 3://unpublished
				$where[] = "a.state=0 and b.state='normal'";
				break;
			case 4://rejected
				$where[] = "a.state=0 and b.state='rejected'";
				break;
		}

		if($filter_order ==""){
			$orderBy = " id desc ";
		}
		else $orderBy = " ".$filter_order." ".$filter_order_Dir;

        $query_c= "select count(*)
		          from  #__content AS a
		          left join #__art_articles_ref as b on a.id = b.articleid"
		.( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" );
        $database->setQuery($query_c);
        $total=$database->loadResult();

        jimport('joomla.html.pagination');
    	$pageNav = new JPagination( $total, $limitstart, $limit );

        if(!_ART_SET_enable_revisions_system) {

            $query_c= "select count(*)
                        from  #__content AS a
                        left join #__art_articles_ref as b on a.id = b.articleid "
        	.( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" );
        
            $database->setQuery($query_c);
            $total = $database->loadResult();

            $finalQuery = "SELECT a.id AS articleId, a.catid, a.created, a.title, a.created_by,a.publish_up, a.hits, a.modified,a.checked_out , a.checked_out_time, a.state, a.introtext, a.fulltext, a.id as id, a.access,
                    b.state AS rstate, b.reason, 
                    c.title AS categoryname,
                    u.name AS username,
                    us.name as checked_out_username ,
                    'content' AS src
		          FROM `#__content` AS a
		          LEFT JOIN `#__art_articles_ref` AS b
                    ON a.id=b.articleid 
		          LEFT JOIN #__categories AS c
                    ON c.id=a.catid
		          LEFT JOIN #__users AS u
                    ON u.id=a.created_by
		          LEFT JOIN #__users AS us
                    ON us.id=a.checked_out "
    		.( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" )
    		. ($orderBy ? 'ORDER BY '.$orderBy : '');
        
        } else {

            $total = 0;
            $query_c1= "select count(*),'content' AS src
                from  `#__content` AS a
                left join #__art_articles_ref as b on a.id = b.articleid "
	          .( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" )
              .( count($having) ? ' HAVING '.implode(' AND ',$having) : '');
            $database->setQuery($query_c1);
            $total += $database->loadResult();

            $query_c2= "select count(*),'revision' AS src
                from  `#__art_revisions` AS a
                left join `#__art_revisions` AS c
                    on a.contentId=c.contentId and a.modified<c.modified
                left join #__art_articles_ref as b on a.id = b.articleid "
	          . "\n WHERE c.modified IS NULL ". ( count( $where ) ?  ' AND '.implode( ' AND ', $where ) : "" )
              .( count($having) ? ' HAVING '.implode(' AND ',$having) : '');
            $database->setQuery($query_c2);
            $total += $database->loadResult();

            $query = "SELECT a.id AS id, a.catid, a.created, a.title, a.created_by,'' as created_by_alias,a.publish_up, a.hits, a.modified, a.checked_out, a.checked_out_time, a.state, a.id as contentId, a.introtext, a.fulltext, a.access,
                        b.state AS rstate,
                        b.reason,
                        c.title AS categoryname,
                        u.name AS username,
                        us.name as checked_out_username ,
                        'content' AS src
    		          FROM `#__content` AS a
    		          LEFT JOIN `#__art_articles_ref` AS b
                        ON a.id=b.articleid 
    		          LEFT JOIN #__categories AS c
                        ON c.id=a.catid
    		          LEFT JOIN #__users AS u
                        ON u.id=a.created_by
    		          LEFT JOIN #__users AS us
                        ON us.id=a.checked_out "
                .( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" );

            $query_rev = "SELECT a.id AS id,a.catid,a.created, a.title,a.created_by,a.created_by_alias,a.publish_up, a.hits, a.modified,a.checked_out , a.checked_out_time, a.state, a.contentId, a.introtext, a.fulltext,  a.access,
                       b.state AS rstate,
                       b.reason,
    		           c.title AS categoryname,
    		           u.name AS username,
                       us.name as checked_out_username ,
                       'revision' AS src
    		          FROM  #__art_revisions AS a 
    		          LEFT JOIN #__art_articles_ref AS b
                        ON a.contentId=b.articleid 
    		          LEFT JOIN #__categories AS c
                        ON c.id=a.catid
    		          LEFT JOIN #__users AS u
                        ON u.id=a.created_by
    		          LEFT JOIN #__users AS us
                        ON us.id=a.checked_out "
                .( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" );

            $finalQuery = 'SELECT uni1.contentId AS id,uni1.catid,uni1.created,uni1.title,uni1.created_by,uni1.created_by_alias,uni1.publish_up,uni1.hits,uni1.modified,uni1.checked_out , uni1.checked_out_time,uni1.state,uni1.rstate, uni1.introtext, uni1.fulltext,  uni1.access,
                       uni1.reason,
    		           uni1.categoryname,
    		           uni1.username,
                       uni1.checked_out_username ,
                       uni1.src,
                       uni1.id AS articleId
                       FROM
                        (('.$query.') UNION ('.$query_rev.')) AS uni1
                        LEFT JOIN
                        (('.$query.') UNION ('.$query_rev.')) AS uni2
                        ON IF(uni1.contentId, uni1.contentId=uni2.contentId, uni1.id=uni2.id)
                        AND uni1.modified<uni2.modified
                        WHERE uni2.modified IS NULL '.
                        ( count($having) ? ' HAVING '.implode(' AND ',$having) : '').
                ' ORDER BY '.($orderBy ? 'uni1.'.$orderBy : ' uni1.modified DESC ');

                      //  ' ORDER BY uni1.modified DESC'
                      //  .($orderBy ? ',uni1.'.$orderBy : '');
        }

        $database->setQuery($finalQuery,$limitstart, $limit);
        //vardump($database->replacePrefix($database->getQuery()),'e',1);
        $rows=$database->loadObjectList();

    	$lists['state'] = $this->HTML_Status_list($filter_state, 1);
        $lists['catid'] = $this->HTML_cat_list($filter_catid);
    	$lists['searchString']=$searchString;
    	$lists['order']=$filter_order;
    	$lists['order_Dir']=$filter_order_Dir;

    	$this->GetRejectReasons($lists);

		HTML_adminArticleman::showArticleList($rows,$pageNav,$lists);
	}

	function publishArticles()
	{
		global $option, $app;

		$chb = JRequest::getVar("cid");
        $this->changeState($chb,1);
		$app->redirect($_SERVER['HTTP_REFERER'],"");
	}

	function unpublishArticles()
	{
        $app = JFactory::getApplication();

		$chb = JRequest::getVar("cid");
        $this->changeState($chb,0);
		$app->redirect($_SERVER['HTTP_REFERER'],"");
	}

	function deleteArticles()
	{
		global $option, $app;
		$database = &JFactory::getDBO();
		$chb = JRequest::getVar("cid");
		$id = JRequest::getVar("id");
		if (count($chb)==0 && $id) $chb[0]=$id;
		
		$getnextpending=JRequest::getVar("getnextpending");
		for ($i=0;$i<count($chb);$i++)
		{
		    $ch=$chb[$i];
            $this->deleteArticle($ch);
		}
        if($getnextpending){
            $database->setQuery("select articleid from #__art_articles_ref where state='pending' order by articleid");
            $id=$database->loadResult();
            $app->redirect("index.php?option=$option&&task=editart&id=".$id);
        }else
		  $app->redirect("index.php?option=$option",JText::_('AMAN_ARTICLE_DELETED'));
	}
	
	function backButton()
	{
		global $option, $app;
	    $app->redirect("index.php?option=$option");
	}
	
	function editArticle()
	{
		global $taks,$option, $app;

		$database =& JFactory::getDBO();
		$user =&JFactory::getUser();
		
		$chb = JRequest::getVar('cid');
        $id = JRequest::getInt('id',0,'default');
		
		if (count($chb)>0) $id=$chb[0];
		
        if( constant('_ART_SET_enable_revisions_system') ) {
            $rev = JTable::getInstance('artrevision');
            $row = $rev->loadByContentId($id);
            $res = $row->title;
        } else {
            $row = JTable::getInstance('content');
            $res = $row->load($id);
		}

		$row->checkout( $user->id );
		//Several Date formatting

		$nullDate = $database->getNullDate();

//UserName
		$query = "SELECT name"
		. "\n FROM #__users"
		. "\n WHERE id = " . (int) $row->created_by
		;
		$database->setQuery( $query );
		$row->creator = $database->loadResult();

//Check if published on frontend
		$query = "SELECT content_id"
		. "\n FROM #__content_frontpage"
		. "\n WHERE content_id = " . (int) $row->id
		;
		$database->setQuery( $query );
		$row->frontpage = $database->loadResult();
		$row->word_banned = articleman_ancestor::checkArticleForBannedWords($row);

//Some lists
        $lists['created_by'] = JHTML::_('list.users', 'created_by', $row->created_by,0,null,'name',0 );
		$this->GetArticleState($row->id,$lists);
		
    	$database->setQuery("select * from #__art_articles_ref where articleid='$row->id'");
    	$cur_state=null;
      	$cur_state = $database->loadAssoc();
      	
      	$chkfrontpage= "";
		if ($row->frontpage && $row->state==1) { $chkfrontpage="checked";} 
		if(_ART_SET_publish_on_frontpage && $cur_state["state"]=="pending") { $chkfrontpage="checked";}
		if($cur_state["state"]=="rejected") { $chkfrontpage="";}
		
		$lists['frontpage'] ="<input name='frontpage' class='inputbox' type='checkbox' value='1' $chkfrontpage >";
		$lists['catid'] = $this->HTML_cat_list($row->catid);
		$this->GetRejectReasons($lists);
		
		if($row->checked_out>0){
			$tmpUser = &JTable::getInstance("user");
			$tmpUser->load($row->checked_out);
			$row->checked_out_username = $tmpUser->name;
			unset($tmpUser);
			$row->checked_out_info = JText::_('AMAN_CHECKED_OUT')." ".$row->checked_out_username." - ".$row->checked_out_time." !";
		}

		HTML_adminArticleman::editArticle($row,$lists);
	}
	
	function saveConfig()
    {
		global $option, $app;

		$database = &JFactory::getDBO();
		$configFile = JPATH_SITE . DS . "components" . DS . "$option" . DS . "config" . DS . "config.php";
		if(!is_writable($configFile))
		if(!chmod ($configFile, 0777))
        	$app->redirect("index.php?option=$option&task=config",JText::_('AMAN_ERR_PERMISSIONS'));

		$fh = fopen($configFile, 'w') or die("can't open config file");

		$stringData  = "<?php\n";
		$stringData .= "define('_ART_SET_content_style','".JRequest::getVar("content_style","1")."');\n";
		
		// ==> particular Joomla 1.0.x content article mode
		$stringData .= "define('_ART_SET_showintro','".JRequest::getVar("showintro","1")."');\n";
		$stringData .= "define('_ART_SET_allow_intro_html','".JRequest::getVar("allow_intro_html","1")."');\n";
		$stringData .= "define('_ART_SET_required_intro','".JRequest::getVar("allow_required","1")."');\n";

		$stringData .= "define('_ART_SET_showmain','".JRequest::getVar("showmain","1")."');\n";
		$stringData .= "define('_ART_SET_allow_main_html','".JRequest::getVar("allow_main_html","1")."');\n";
		$stringData .= "define('_ART_SET_required_main','".JRequest::getVar("allow_main","1")."');\n";
		// <== particular Joomla 1.0.x content article mode
		 
		// ==> particular Joomla 1.5.x content article mode
		$stringData .= "define('_ART_SET_art_text_html','".JRequest::getVar("art_text_html","1")."');\n";
		$stringData .= "define('_ART_SET_art_text_required','".JRequest::getVar("art_text_required","1")."');\n";
		// <== particular Joomla 1.5.x content article mode
		
		$stringData .= "define('_ART_SET_canDelete','".JRequest::getVar("candelete","1")."');\n";
		$stringData .= "define('_ART_SET_canUnpublish','".JRequest::getVar("canunpublish","1")."');\n";
		$stringData .= "define('_ART_SET_canEditDates','".JRequest::getVar("caneditdates","1")."');\n";
		$stringData .= "define('_ART_SET_allow_set_hour','".JRequest::getVar("allow_set_hour","1")."');\n";
		$stringData .= "define('_ART_SET_allow_set_enddate','".JRequest::getVar("allow_set_enddate","1")."');\n";
		$stringData .= "define('_ART_SET_enable_ordering','".JRequest::getVar("art_enable_ordering","1")."');\n";
		
		$stringData .= "define('_ART_SET_publish_on_frontpage','".JRequest::getVar("publish_on_frontpage","1")."');\n";
		$stringData .= "define('_ART_SET_allowmetdata','".JRequest::getVar("allowmetdata","1")."');\n";
		$stringData .= "define('_ART_SET_default_publishing_period','".JRequest::getVar("default_publishing_period",365)."');\n";

		$stringData .= "define('_ART_SET_nrlinks','".JRequest::getVar("nrlinks","4")."');\n";
		$stringData .= "define('_ART_SET_nrlinks_resourcebox','".JRequest::getVar("nrlinks_res","2")."');\n";
		$stringData .= "define('_ART_SET_nrimages','".JRequest::getVar("nrimages","")."');\n";
		$stringData .= "define('_ART_SET_concat_resourcebox','".JRequest::getVar("concat_resourcebox","2")."');\n";
		$stringData .= "define('_ART_SET_enable_resourcebox','".JRequest::getVar("enable_resourcebox","2")."');\n";
		$stringData .= "define('_ART_SET_allowed_tags','".JRequest::getVar("allowed_tags","")."');\n";
		$stringData .= "define('_ART_SET_allowed_groups','".implode("," ,JRequest::getVar("allowed_groups",""))."');\n";
		$stringData .= "define('_ART_SET_allowed_to_aprouve_groups','".implode("," ,JRequest::getVar("allowed_to_aprouve_groups",""))."');\n";
		
		$stringData .= "define('_ART_SET_pendingAuthor','".JRequest::getVar("pendingAuthor","1")."');\n";
		$stringData .= "define('_ART_SET_pendingAdmin','".JRequest::getVar("pendingAdmin","1")."');\n";
		$stringData .= "define('_ART_SET_rejectAuthorEmail','".JRequest::getVar("rejectAuthorEmail","1")."');\n";
		$stringData .= "define('_ART_SET_acceptAuthorEmail','".JRequest::getVar("acceptAuthorEmail","1")."');\n";
        $stringData .= "define('_ART_SET_acceptAuthorMsgEmail','".JRequest::getVar("acceptAuthorMsgEmail","1")."');\n";
		$stringData .= "define('_ART_SET_unpublishEmail','".JRequest::getVar("unpublishEmail","1")."');\n";
		$stringData .= "define('_ART_SET_limit_minim_chars','".JRequest::getVar("limit_minim_chars","")."');\n";
		$stringData .= "define('_ART_SET_limit_maxim_chars','".JRequest::getVar("limit_maxim_chars","")."');\n";
		$stringData .= "define('_ART_SET_alert_words','".JRequest::getVar("alert_words","")."');\n";
		$stringData .= "define('_ART_SET_mail_from_name','".JRequest::getVar("art_mail_from_name","")."');\n";
		$stringData .= "define('_ART_SET_mail_from_email','".JRequest::getVar("art_mail_from_email","")."');\n";
		$stringData .= "define('_ART_SET_allow_author_image','".JRequest::getVar("art_allow_author_image","")."');\n";
		$stringData .= "define('_ART_SET_allowed_extensions','".JRequest::getVar("art_author_image_extensions","")."');\n";
		$stringData .= "define('_ART_SET_max_size','".JRequest::getVar("art_author_max_size","")."');\n";
		$stringData .= "define('_ART_SET_allowalias','".JRequest::getVar("allowalias","")."');\n";
		$stringData .= "define('_ART_SET_usecheckin','".JRequest::getVar("usecheckin","")."');\n";
		$stringData .= "define('_ART_SET_showcreationdate','".JRequest::getVar("showcreationdate","")."');\n";
		$stringData .= "define('_ART_SET_ticketpreapproval','".JRequest::getVar("ticketpreapproval","")."');\n";
		$stringData .= "define('_ART_SET_userchoosesapprover','".JRequest::getVar("userchoosesapprover","")."');\n";
		$stringData .= "define('_ART_SET_onesuperadminonly','".JRequest::getVar("onesuperadminonly","")."');\n";
		$stringData .= "define('_ART_SET_allow_set_access_level','".JRequest::getVar("allow_set_access_level","")."');\n";
		
		$stringData .= "define('_ART_SET_anonymous_submission','".JRequest::getVar("anonymous_submission","")."');\n";
		$stringData .= "define('_ART_SET_anonymous_captcha','".JRequest::getVar("anonymous_captcha","")."');\n";
		$stringData .= "define('_ART_SET_anonymous_confirm_email','".JRequest::getVar("anonymous_confirm_email","")."');\n";

		$stringData .= "define('_ART_SET_recaptcha_public_key','".JRequest::getVar("recaptcha_public_key","")."');\n";
		$stringData .= "define('_ART_SET_recaptcha_private_key','".JRequest::getVar("recaptcha_private_key","")."');\n";
		$stringData .= "define('_ART_SET_article_upload_file','".JRequest::getVar("article_upload_file","")."');\n";

        $stringData .= "define('_ART_SET_enable_revisions_system','".JRequest::getVar("enable_revisions_system","")."');\n";
        $stringData .= "define('_ART_SET_nr_revisions_saved','".JRequest::getVar("nr_revisions_saved","")."');\n";
		//$stringData .= "define('_ART_SET_','".JRequest::getVar("","")."');\n";

		$stringData .= "?>";
		fwrite($fh, $stringData);
		fclose($fh);

		$subj = JRequest::getVar('reject_subject','','default','string',4);
		$templ = JRequest::getVar('reject_body','','default','string',4);
		$database->setQuery("update #__art_emailtmpl set subject='".$database->getEscaped($subj)."', template='".$database->getEscaped($templ)."' where type='reject' ");
		$database->query();

		$subj = JRequest::getVar('publish_subject','','default','string',4);
		$templ = JRequest::getVar('publish_body','','default','string',4);
		$database->setQuery("update #__art_emailtmpl set subject='".$database->getEscaped($subj)."', template='".$database->getEscaped($templ)."' where type='publish' ");
		$database->query();

		$subj = JRequest::getVar('pendingAuthor_subject','','default','string',4);
		$templ = JRequest::getVar('pendingAuthor_body','','default','string',4);
		$database->setQuery("update #__art_emailtmpl set subject='".$database->getEscaped($subj)."', template='".$database->getEscaped($templ)."' where type='pendingAuthor' ");
		$database->query();

		$subj = JRequest::getVar('pendingAdmin_subject','','default','string',4);
		$templ = JRequest::getVar('pendingAdmin_body','','default','string',4);
		$database->setQuery("update #__art_emailtmpl set subject='".$database->getEscaped($subj)."', template='".$database->getEscaped($templ)."' where type='pendingAdmin' ");
		$database->query();

		$subj = JRequest::getVar('unpublish_subject','','default','string',4);
		$templ = JRequest::getVar('unpublish_body','','default','string',4);
		$database->setQuery("update #__art_emailtmpl set subject='".$database->getEscaped($subj)."', template='".$database->getEscaped($templ)."' where type='unpublish' ");
		$database->query();

		$subj = JRequest::getVar('publish_w_msg_subject','','default','string',4);
		$templ = JRequest::getVar('publish_w_msg_body','','default','string',4);
		$database->setQuery("update #__art_emailtmpl set subject='".$database->getEscaped($subj)."', template='".$database->getEscaped($templ)."' where type='publish_w_msg' ");
		$database->query();

		global $cb_fieldmap;
	
		$keys=array_keys($cb_fieldmap);
		for ($i=0; $i<count($keys); $i++ ){
	    	$fld=$keys[$i];
			$cb=$_REQUEST[$fld];
			$database->setQuery("update #__art_cbfields set cb_field='$cb' where field='$fld'");
			$database->query();
	    }

		
        $app->redirect("index.php?option=$option&task=config",JText::_('AMAN_CONFIGURATION_SAVED'));
    }
    
	function createConfigFile()
	{
		require(JPATH_COMPONENT_ADMINISTRATOR.DS.'admin.articleman.xajax.php');
		$adminXajax = new JArticlemanAdminXajax;
		$xMethods =& $adminXajax->getXajaxMethods();

		$database = &JFactory::getDBO();
		$acl	  =& JFactory::getACL();

	    $lists=array();
		$custom_mode_javascript = " onclick='articleman_JS_toggle_mode(this.value);'";
	    $lists['content_style']= JHTML::_('select.booleanlist','content_style',"class='inputbox' {$custom_mode_javascript} ", _ART_SET_content_style,"Joomla 1.5.x mode" , "Joomla 1.0.x mode");
		
	    // ==> mode Joomla 1.5.x particular settings
		$lists['art_text_required']=JHTML::_('select.booleanlist', 'art_text_required','class="inputbox"',_ART_SET_art_text_required);
		$lists['art_text_html']= JHTML::_('select.booleanlist', 'art_text_html','class="inputbox"',_ART_SET_art_text_html);
	    // <== mode Joomla 1.5.x particular settings
	    
	    // ==> mode Joomla 1.0.x particular settings
	    $lists['showintro']=JHTML::_('select.booleanlist', 'showintro','class="inputbox"', _ART_SET_showintro);
		$lists['allow_intro_html']=JHTML::_('select.booleanlist', 'allow_intro_html','class="inputbox"',_ART_SET_allow_intro_html);
		$lists['allow_required']=JHTML::_('select.booleanlist', 'allow_required','class="inputbox"',_ART_SET_required_intro);

	    $lists['showmain']=JHTML::_('select.booleanlist', 'showmain','class="inputbox"', _ART_SET_showmain);
		$lists['allow_main_html']=JHTML::_('select.booleanlist', 'allow_main_html','class="inputbox"',_ART_SET_allow_main_html);
		$lists['allow_main']=JHTML::_('select.booleanlist', 'allow_main','class="inputbox"',_ART_SET_required_main);
	    // <== mode Joomla 1.0.x particular settings
		
		$lists['publish_on_frontpage']=JHTML::_('select.booleanlist', 'publish_on_frontpage','class="inputbox"',_ART_SET_publish_on_frontpage);
	    $lists['candelete']=JHTML::_('select.booleanlist', 'candelete','class="inputbox"',_ART_SET_canDelete);
	    $lists['canunpublish']=JHTML::_('select.booleanlist', 'canunpublish','class="inputbox"',_ART_SET_canUnpublish);
	    $lists['caneditdates']=JHTML::_('select.booleanlist', 'caneditdates','class="inputbox"',_ART_SET_canEditDates);
		$lists['allow_set_enddate']=JHTML::_('select.booleanlist', 'allow_set_enddate','class="inputbox"',_ART_SET_allow_set_enddate);
		$lists['allow_set_hour'] = JHTML::_('select.booleanlist','allow_set_hour','class="inputbox"',_ART_SET_allow_set_hour);
	    $lists['allowmetdata']=JHTML::_('select.booleanlist', 'allowmetdata','class="inputbox"',_ART_SET_allowmetdata);
		$lists['enable_resourcebox']=JHTML::_('select.booleanlist', 'enable_resourcebox','class="inputbox"',_ART_SET_enable_resourcebox);
		$lists['concat_resourcebox']=JHTML::_('select.booleanlist', 'concat_resourcebox','class="inputbox"',_ART_SET_concat_resourcebox);

		$lists['default_publishing_period'] = '<input type="text" name="default_publishing_period" value="'._ART_SET_default_publishing_period.'" /> days';
		
		// ==> since 1.5.6
		$lists["limit_minim_chars"] = _ART_SET_limit_minim_chars;
		$lists["limit_maxim_chars"] = _ART_SET_limit_maxim_chars;
		// <== since 1.5.6

		// ==> since 1.5.7
		$lists["art_mail_from_name"] = '<input type="text" name="art_mail_from_name" style="width:290px;" value="'._ART_SET_mail_from_name.'"> ';
		$lists["art_mail_from_email"] = '<input type="text" name="art_mail_from_email" style="width:290px;" value="'._ART_SET_mail_from_email.'"> ';

		$lists["art_allow_author_image"] = JHTML::_('select.booleanlist', 'art_allow_author_image','class="inputbox"',_ART_SET_allow_author_image);
		$lists["art_author_image_extensions"] = '<input type="text" name="art_author_image_extensions" style="width:290px;" value="'._ART_SET_allowed_extensions.'"> ';
		$lists["art_author_max_size"] = '<input type="text" name="art_author_max_size" style="width:290px;" value="'._ART_SET_max_size.'"> ';
		$lists['art_enable_ordering']=JHTML::_('select.booleanlist', 'art_enable_ordering','class="inputbox"',_ART_SET_enable_ordering);
		// <== since 1.5.7

		$database->setQuery(
			"SELECT `a`.`id` AS value, CONCAT( REPEAT('--', COUNT(`c2`.`id`) ), `a`.`title` ) as text
			  FROM `#__usergroups` AS a
			  LEFT
			  OUTER JOIN `#__usergroups` AS c2
			  ON a.lft > c2.lft
			  AND a.rgt < c2.rgt
			  GROUP BY a.id
			  ORDER BY a.lft ASC "
		);
		$userGroups = $database->loadAssocList();
		$lists['allowed_groups'] = JHTML::_('select.genericlist',$userGroups,'allowed_groups[]', 'size="'.count($userGroups).'" multiple=""', 'value', 'text' , explode(',',_ART_SET_allowed_groups) );
		$lists['allowed_to_aprouve_groups'] = JHTML::_('select.genericlist',$userGroups,'allowed_to_aprouve_groups[]', 'size="'.count($userGroups).'" multiple=""', 'value', 'text' ,explode(',',_ART_SET_allowed_to_aprouve_groups) );
		

		$aGroups=array();
		$aGroups[] = JHTML::_('select.option',0,'Select group...');
		$aGroups = array_merge($aGroups,$userGroups);
		$lists['restrict_groups'] = JHTML::_('select.genericlist',$aGroups,'restrict_group','size="'.count($aGroups).'"');
		
		$categories = JHTML::_('category.options','com_content');
		$lists['restrict_categories'] = JHTML::_('select.genericlist',$categories,'restrict_categories','size="7" multiple="" onchange="activateApplyButton();"');

		$xMethods['saverestriction']->setParameter(0,XAJAX_JS_VALUE,'document.getElementById(\'restrict_group\').value');
		$xMethods['saverestriction']->setParameter(1,XAJAX_JS_VALUE,'getMultipleSelectValues(\'restrict_categories\')');

	    $lists['rejectAuthorEmail']=JHTML::_('select.booleanlist', 'rejectAuthorEmail','class="inputbox"',_ART_SET_rejectAuthorEmail);
	    $lists['acceptAuthorEmail']=JHTML::_('select.booleanlist', 'acceptAuthorEmail','class="inputbox"',_ART_SET_acceptAuthorEmail);
        $lists['acceptAuthorMsgEmail']=JHTML::_('select.booleanlist', 'acceptAuthorMsgEmail','class="inputbox"',_ART_SET_acceptAuthorMsgEmail);
	    $lists['pendingAuthor']=JHTML::_('select.booleanlist', 'pendingAuthor','class="inputbox"',_ART_SET_pendingAuthor);
		$lists['pendingAdmin']=JHTML::_('select.booleanlist', 'pendingAdmin','class="inputbox"',_ART_SET_pendingAdmin);
		$lists['unpublishEmail']=JHTML::_('select.booleanlist', 'unpublishEmail','class="inputbox"',_ART_SET_unpublishEmail);
		
		$lists['alert_words']="<textarea id='alert_words' name='alert_words' style='height:100px; width:300px;'>"._ART_SET_alert_words."</textarea>";

	    $database->setQuery("select * from #__art_emailtmpl");
	    $templates=$database->loadObjectList();
	    
	    for ($i=0;$i<count($templates);$i++){
	        $lists[$templates[$i]->type.'_subject']=$templates[$i]->subject;
	        $lists[$templates[$i]->type.'_body']=$templates[$i]->template;
		}
		
		$fields = array();
		$database->setQuery("SELECT COUNT(1) FROM `#__extensions` WHERE `type`='component' AND `element`='com_comprofiler'");
		if($database->loadResult()){
			$query = "SELECT `name` as value,concat(`name`,concat(' - ',title)) as text FROM #__comprofiler_fields where sys=0 or type='image'";
		    $database->setQuery($query);
			$fields = $database->loadObjectList();
			$fields = array_merge(array(JHTML::_('select.option','','-'.JText::_("AMAN_SELECT_CBFIELD").'-')),$fields);
		}

	    $lists["fields"] = $fields;
		
	    // since 1.7.4
	    $lists['allowalias']=JHTML::_('select.booleanlist', 'allowalias','class="inputbox"',_ART_SET_allowalias);
	    $lists['usecheckin']=JHTML::_('select.booleanlist', 'usecheckin','class="inputbox"',_ART_SET_usecheckin);
	    $lists['showcreationdate']=JHTML::_('select.booleanlist', 'showcreationdate','class="inputbox"',_ART_SET_showcreationdate);
	    
	    // since 1.7.5
	    $lists['ticketpreapproval']=JHTML::_('select.booleanlist', 'ticketpreapproval','class="inputbox"',_ART_SET_ticketpreapproval);
	    $lists['userchoosesapprover'] = JHTML::_('select.booleanlist', 'userchoosesapprover','class="inputbox"',_ART_SET_userchoosesapprover);
	    $lists['onesuperadminonly']=JHTML::_('select.booleanlist', 'onesuperadminonly','class="inputbox"',_ART_SET_onesuperadminonly);
	    
	    $lists['allow_set_access_level'] = JHTML::_('select.booleanlist', 'allow_set_access_level','class="inputbox"',_ART_SET_allow_set_access_level);
	    
		$lists['anonymous_submission'] = JHTML::_('select.booleanlist','anonymous_submission','class="inputbox"',_ART_SET_anonymous_submission);
		$lists['anonymous_captcha'] = JHTML::_('select.booleanlist','anonymous_captcha','class="inputbox"',_ART_SET_anonymous_captcha);
		$lists['anonymous_confirm_email'] = JHTML::_('select.booleanlist','anonymous_confirm_email','class="inputbox"',_ART_SET_anonymous_confirm_email);
	    $lists['article_upload_file'] = JHTML::_('select.booleanlist','article_upload_file','class="inputbox"',_ART_SET_article_upload_file);
	    
	    $lists['xmethods'] =& $xMethods;
	    
		HTML_adminArticleman::configForm($lists);
	}
	
	function saveArticle()
	{
		global $option,$app;

		$database = &JFactory::getDBO();

        $articol = & JTable::getInstance('content');
        

		$cid = JRequest::getVar('cid',0);
		$id = $cid[0];
		$getnextpending = JRequest::getVar('getnextpending',0);

		if (!$id)
		{
			$app->redirect("index.php?option=$option",JText::_('AMAN_ERR_ARTICLE_REJECTED'));
            return;
		}

		$articol->id = $id;
        $articol->title = stripslashes(JRequest::getVar("title",""));

        $articol->introtext = stripslashes(JRequest::getVar('introtext', '', 'post', 'string', JREQUEST_ALLOWRAW));
        $articol->fulltext = stripslashes(JRequest::getVar('maintext', '', 'post', 'string', JREQUEST_ALLOWRAW));

		//$articol->introtext = stripslashes(JRequest::getVar("introtext",""));
		//$articol->fulltext = stripslashes(JRequest::getVar("maintext",""));
		$articol->catid = JRequest::getVar("filter_catid");
		$articol->created_by = JRequest::getVar("created_by");
		$articol->created_by_alias = JRequest::getVar("authoralias");

		$articol->metadesc= JRequest::getVar("metadesc");
		$articol->metakey= JRequest::getVar("metakey");
		
		$articol->created= JRequest::getVar("created");
		$articol->publish_up= JRequest::getVar("publish_up");
		$articol->publish_down= JRequest::getVar("publish_down");

		$articol->state=1;

     	if (!$articol->check()) {
    		echo "<script> alert('".$articol->getError()."'); window.history.go(-1); </script>\n";
    		exit();
    	}

        if( constant('_ART_SET_enable_revisions_system') ) {
            $revision =& JTable::getInstance('artrevision');
            $res = $revision->store($articol,'normal');               
        } else {
            $res = $articol->store();
        }

        if( !$res ) {
			$lists = $this->reBuildLists($articol);
            $err = array_merge($err,$articol->getErrors());
            JError::raiseNotice(1, implode( '<br />', $err ) );
			return;
		}

		$database->setQuery("SELECT COUNT(*) FROM #__art_articles_ref WHERE articleid='$id'");

        if($database->loadResult()>0) {
    		$database->setQuery("UPDATE #__art_articles_ref SET state='normal',reason='' WHERE articleid='$id'");
		} else {
    		$database->setQuery("INSERT INTO #__art_articles_ref SET state='normal', articleid='$id'");
		}
		$database->query();

		// manage frontpage items
		JTable::addIncludePath(JPATH_ADMINISTRATOR. DS . 'components' . DS . 'com_content' . DS . 'tables' );

    	$fp = JTable::getInstance('Featured','ContentTable');

		if (intval( JRequest::getVar('frontpage', 0 ) )) {
    		// toggles go to first place
    		if (!$fp->load( (int)$articol->id )) {
    			// new entry
    			$query = "INSERT INTO #__content_frontpage"
    			. "\n VALUES ( " . (int) $articol->id . ", 1 )"
    			;
    			$database->setQuery( $query );
    			if (!$database->query()) {
    				echo "<script> alert('".$database->stderr()."');</script>\n";
    				exit();
    			}
    			$fp->ordering = 1;
    		}
    	} else {
    		// no frontpage mask
    		if (!$fp->delete( (int)$articol->id )) {
    			$msg .= $fp->stderr();
    		}
    		$fp->ordering = 0;
    	}
    	$fp->reorder();

    	$articol->checkin();
        if (_ART_SET_acceptAuthorEmail)
      		$this->sendMail($articol,'publish');

        if($getnextpending){
			$database->setQuery("select articleid from #__art_articles_ref where state='pending' order by articleid");
			
			$id=$database->loadResult();
			if($id){
				$app->redirect("index.php?option=$option&task=editart&id=".$id);
				return;
            }
        }
		$app->redirect("index.php?option=$option",JText::_('AMAN_ARTICLE_SAVED'));
	}

	function rejectArt()
    {
        global $option, $app;

		$database = &JFactory::getDBO();

        $cid=JRequest::getVar('cid',array(),'default','array');

		$getnextpending=JRequest::getVar("getnextpending");
        $reason=addslashes(JRequest::getVar('message2authors'));

        foreach($cid as $id)
        {
        	$msg .= $this->rejectArticle($id,$reason).'<br />';
        }
        $app->redirect("index.php?option=$option",$msg);
        
        return;	  
    }
    
	function listReasons()
    {
		$database = &JFactory::getDBO();
        
        $database->setQuery("select * from #__art_reason order by title");
        $rows=$database->loadObjectList();

        HTML_adminArticleman::ListReasons($rows);
    }
    
	function editReason()
    {
		$database = &JFactory::getDBO();
        
        $id=JRequest::getVar('id');
        $database->setQuery("select * from #__art_reason where id='$id'");
        $row=null;
        $row = $database->loadObject();

        HTML_adminArticleman::EditReason($row);
    }
    
	function saveReason()
    {
    	global $app;
		$database = &JFactory::getDBO();
        
        $id=JRequest::getVar('id');
        
        $title=JRequest::getVar( "title", "");
        $reason=JRequest::getVar( "reason", "");
        $toolbar=JRequest::getVar('toolbar');

        if($id){
			$database->setQuery("update #__art_reason set title='$title',reason='$reason', toolbar ='$toolbar' where id='$id'");
        }else{
        	$database->setQuery("insert into  #__art_reason set  title='$title',reason='$reason', toolbar ='$toolbar'");
        }
        $database->query();
        $app->redirect("index.php?option=com_articleman&task=listReasons",'');
    }
    
	function newReason()
    {
        $row=new stdClass();
        $row->title='';
        $row->reason='';
        $row->id='';
        $row->toolbar='';
        HTML_adminArticleman::EditReason($row);
    }
    
	function deleteReason()
    {
    	global $app;
		$database = &JFactory::getDBO();
		
        $cid=JRequest::getVar('cid');
        if (is_array($cid)){
            $id=implode(',',$cid);
        }else $id=$cid;
        $database->setQuery("delete from #__art_reason where id in ($id)");
        $database->query();

        $app->redirect("index.php?option=com_articleman&task=listReasons",'');
    }
    
	function AboutArticle()
    {
        global $option;
 
        require_once( JPATH_SITE. DS . "administrator" . DS . "components" . DS . "$option" . DS . "version_info.php");
        $version=new component_version_info($option);
    	HTML_adminArticleman::showAbout( $option,$version);
    }

	function changeaccess()
	{
		global $option;
		$app =& JFactory::getApplication();

		$id = JRequest::getVar('id');
		$article =& JTable::getInstance('content');
		if(!$article->load($id))
		{
			$app->redirect('index.php?option='.$option,'Article does not exist!');
			return false;
		}

		$article->access = $article->access % 3 + 1;

		$article->store();
		$app->redirect('index.php?option='.$option);
	}

	function frontpagemanager()
	{
		$where = array();
		$database = &JFactory::getDBO();
		$jconfig = new JConfig;
		$list_limit = $jconfig->list_limit;

        $limitstart= JArrayHelper::getValue($_SESSION,"limitstart",0);
		$limit = JArrayHelper::getValue($_SESSION,"limit",$list_limit);

        $searchString = JArrayHelper::getValue($_SESSION,"searchstring","");

		$filter_catid= JArrayHelper::getValue($_SESSION,"filter_catid",0);

		$filter_state= JArrayHelper::getValue($_SESSION,"filter_state",1);

		$filter_order= JArrayHelper::getValue($_SESSION,"filter_order",'');
		$filter_order_Dir= JArrayHelper::getValue($_SESSION,"filter_order_Dir",'');

		$limitstart= JRequest::getVar("limitstart",$limitstart);$limit = JRequest::getVar("limit",$limit);
        $searchString = JRequest::getVar("searchstring",$searchString);

		$filter_catid= JRequest::getVar("filter_catid",$filter_catid);
		$filter_state= JRequest::getVar("filter_state",$filter_state);
		$filter_order= JRequest::getVar("filter_order",$filter_order);$filter_order_Dir= JRequest::getVar("filter_order_Dir",$filter_order_Dir);

		$_SESSION["limitstart"]=$limitstart;$_SESSION["limit"]=$limit;
		$_SESSION["searchstring"]=$searchString;
		$_SESSION["filter_catid"]=$filter_catid;
		$_SESSION["filter_state"]=$filter_state;
		$_SESSION["filter_order"]=$filter_order;$_SESSION["filter_order_Dir"]=$filter_order_Dir;

		//$where[] = "b.state <> 'draft'";
		if ($searchString)
		{
			$searchTerm = $database->getEscaped($searchString);
			$where[]= " (a.title like '%$searchTerm%' or a.introtext like '%$searchTerm%' or a.fulltext like '%$searchTerm%')";
		}
    	if($filter_catid)
            $where[]= "a.catid='".(int)$filter_catid."'";
		switch ($filter_state)
		{
			case 1://pending
				$where[]= "a.state=0 and (b.state='pending')";
				break;
			case 2://published
				$where[]= "a.state=1";
				break;
			case 3://unpublished
				$where[] = "a.state=0 and b.state='normal'";
				break;
			case 4://rejected
				$where[] = "a.state=0 and b.state='rejected'";
				break;
		}

		if($filter_order ==""){
			$orderBy = " a.id desc ";
		}
		else $orderBy = " ".$filter_order." ".$filter_order_Dir;

		 $query_c= "select count(*)
		          from  #__content_frontpage AS cf
		          left join #__content AS a on cf.content_id=a.id
		          left join #__art_articles_ref as b on a.id = b.articleid"
		.( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" );
        $database->setQuery($query_c);
        $total=$database->loadResult();

        jimport('joomla.html.pagination');
    	$pageNav = new JPagination( $total, $limitstart, $limit );

		$query = "select a.*,cf.ordering AS fpordering,
				  b.state as rstate,b.reason, 
		          c.title as categoryname,
		          u.name as username
		          from  #__content_frontpage AS cf
		          right join #__content AS a on cf.content_id=a.id
		          left join #__art_articles_ref as b on a.id = b.articleid
		          left join #__categories as c on c.id = a.catid
		          left join #__art_reason as r on b.reason = r.id 
		          left join #__users as u on u.id = a.created_by
		          "
		.( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" )
		." order by ".$orderBy;
        $database->setQuery($query,$limitstart,$limit);

		$rows=$database->loadObjectList();

    	$lists['state'] = $this->HTML_Status_list($filter_state, 1);
        $lists['catid'] = $this->HTML_cat_list($filter_catid);
    	$lists['searchString']=$searchString;
    	$lists['order']=$filter_order;
    	$lists['order_Dir']=$filter_order_Dir;

		HTML_adminArticleman::showFrontPageArticles($rows,$pageNav,$lists);
	}
	
	function fporderup()
	{
		global $option;
		$database =& JFactory::getDBO();
		$app =& JFactory::getApplication();

		$cid = JRequest::getVar('cid',0,'default','array');
		$id = $cid[0];

		JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_content'.DS.'tables');
        $fp =& JTable::getInstance('featured','ContentTable');

		$fp->load( $id );
		$fp->move( -1 );

		$cache = & JFactory::getCache('com_content');
		$cache->clean();

		$app->redirect($_SERVER['HTTP_REFERER']);
	}
 
 	function fporderdown()
	 {
	 	global $option;
		$database =& JFactory::getDBO();
		$app =& JFactory::getApplication();

		$cid = JRequest::getVar('cid',0,'default','array');
		$id = $cid[0];

        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_content'.DS.'tables');
		$fp =& JTable::getInstance('featured','ContentTable');
		$fp->load( $id );
		$fp->move( 1 );

		$cache = & JFactory::getCache('com_content');
		$cache->clean();

		$app->redirect($_SERVER['HTTP_REFERER']);
	 }

	function saveOrder()
	{
		global $app;
		
		$cid = JRequest::getVar('cid',0,'default','array');

		$db 	=& JFactory::getDBO();
		$total	= count( $cid );
		$order 	= JRequest::getVar( 'order', array(0), 'post', 'array' );
	
		for( $i=0; $i < $total; $i++ )
		{
			$query = 'UPDATE #__content_frontpage'
			. ' SET ordering = ' . (int) $order[$i]
			. ' WHERE content_id = ' . (int) $cid[$i];
			$db->setQuery( $query );

			$db->query();
		}
	
		$cache = & JFactory::getCache('com_content');
		$cache->clean();
	
		$msg 	= JText::_( 'New ordering saved' );
		$app->redirect( $_SERVER['HTTP_REFERER'], $msg );
	}

	function publishart_w_msg()
	{
		global $option;
		$app =& JFactory::getApplication();

		$chb = JRequest::getVar('cid');
		$msg = JRequest::getVar('message2authors');

		//$this->sendMessage2Authors($chb,$msg);
		$this->changeState($chb,2);

		$app->redirect($_SERVER['HTTP_REFERER'],"");
	}

	function sendMessage2Authors($ids,$msg)
	{
		$app =& JFactory::getApplication();

		$sArticleIds = implode(',',$ids);
		$database =& JFactory::getDBO();
		$database->setQuery("SELECT c.id,c.title,u.email FROM `#__content` AS c LEFT JOIN `#__users` AS u ON `c`.`created_by`=`u`.`id` WHERE `c`.`id` IN (".$sArticleIds.")");
		$res = $database->loadObjectList();

		foreach($res as $v)
		{
			$subject = JText::printf('AMAN_YOUR_ARTICLE_PUBLISHED',$v->title);
			
			$body = $msg;
			JUtility::sendMail( $app->getCfg('mailfrom'), $app->getCfg('fromname'), $v->email, $subject, $body  );
		}

		return true;
	}

	function show_pwm()
	{
		HTML_adminArticleman::show_pwm();
	}

	function generaterejectform()
	{
		$lists = array();
		$this->GetRejectReasons($lists);
		HTML_adminArticleman::generaterejectform($lists);
	}
}
?>