<?php
/**------------------------------------------------------------------------
com_articleman -  Article Factory Manager 3.1.6
------------------------------------------------------------------------
 * @author TheFactory
 * @copyright Copyright (C) 2012 SKEPSIS Consult SRL. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: http://www.thefactory.ro
 * Technical Support: Forum - http://www.thefactory.ro/joomla-forum/
-------------------------------------------------------------------------*/

defined( '_JEXEC' ) or die( 'Restricted access' );

require(JPATH_COMPONENT_ADMINISTRATOR.DS.'thefactory.xajax.php');

class JArticlemanAdminXajax extends JTheFactoryXajax{
	
	function JArticlemanAdminXajax(){
		$aCallableObjects = array();
		$aCallableObjects[] = new ArtAdminXajaxMethods;

		$aCallableFunctions = array();

		parent::__construct($aCallableObjects,$aCallableFunctions,true);
	}

}

class ArtAdminXajaxMethods{
	
	//this property is populated by JTheFactoryXajax class, when it registers an instance of this class;
	//it is needed, for example, in "listCategories" method, when sending back a js call to the "deleteRestriction" method
	//if you have a better idea, do tell
	var $xajaxMethods = null;

	function saveRestriction($groupId,$categoryIds=array()){
		$objResponse = new xajaxResponse();

		$groupId = (int) $groupId;
		if(!$groupId){
			$objResponse->alert('No group selected!');
			return $objResponse;
		}
		if(!count($categoryIds)){
			$objResponse->alert('No category selected!');
			return $objResponse;
		}

		foreach($categoryIds as $k=>$catId)
		{
			if(!is_string($catId) && !is_int($catId))
			{
				unset($categoryIds[$k]);
			}
		}

		$file = JPATH_COMPONENT_SITE.DS.'config'.DS.'restrictions.php';
		require($file);
		if(!isset($groupRestrictions)){
			$groupRestrictions = array();
		}
		if(isset($groupRestrictions[$groupId])){
			foreach($categoryIds as $catId){
				if(!in_array($catId,$groupRestrictions[$groupId])){
					array_push($groupRestrictions[$groupId],$catId);
				}
			}
		}
		else{
			$groupRestrictions[$groupId]=$categoryIds;
		}

		_rewriteRestrictionsFile($groupRestrictions);

		$database =& JFactory::getDBO();
		$database->setQuery("SELECT `title` FROM `#__usergroups` WHERE `id`='".$database->getEscaped($groupId)."'");
		$objResponse->alert('Restriction saved for group "'.$database->loadResult().'"');

		return $this->listRestrictions($objResponse);
	}
	
	function listRestrictions($objResponse = null){
		if(!$objResponse)
			$objResponse = new xajaxResponse();
		
		$database =& JFactory::getDBO();
		$xMethods =& $this->xajaxMethods;

		$file = JPATH_COMPONENT_SITE.DS.'config'.DS.'restrictions.php';
		require($file);
		if(!isset($groupRestrictions)){
			$groupRestrictions = array();
		}
		if(!count($groupRestrictions))
		{
			return $objResponse;
		}
		
		$htmlResponse = '';
		$restrictionTpl =
			'<div id="group_{$gid}_container" style="width:100%; border: solid 1px #E7E7E7; font-weight:bold; padding:4px;">'.
				'<div style="width:25%;float:left;">{$groupName}&nbsp;'.
					'<a href="#" onclick="if(confirm(\'Remove restrictions for group &quot;{$groupName}&quot;?\')){{$xajaxDeleteCall}} return false;  "><img src="'.JURI::root().'components/com_articleman/images/rejected.png" /></a>'.
				'</div>'.
				'<div style="width:70%;float:left;">{$restrictedCategoriesLinks}</div>'.
				'<div style="clear:both"></div>'.
			'</div><br />';

		foreach($groupRestrictions as $gid=>$restrictedCategories)
		{
			$database->setQuery("SELECT `title` FROM `#__usergroups` WHERE `id`='".$database->getEscaped($gid)."'");
			$groupName = $database->loadResult();

			$restrictedCategoriesIds = implode(',',$restrictedCategories);
			$database->setQuery("SELECT `id`,`title` FROM `#__categories` WHERE `id` IN (".$restrictedCategoriesIds.")");
			$aRestrictedCategoriesNames = $database->loadAssocList();
			$restrictedCategoriesLinks = '';
			foreach($aRestrictedCategoriesNames as $rc){
				$restrictedCategoriesLinks .= '<a href="#">'.$rc['title'].'</a>&nbsp;&nbsp;&nbsp;';
			}
			$xMethods['deleterestriction']->setParameter(0,XAJAX_QUOTED_VALUE,$gid);
			$xajaxDeleteCall = $xMethods['deleterestriction']->getScript();

			$patterns = array('#\{\$gid\}#','#\{\$groupName\}#','#\{\$restrictedCategoriesLinks\}#','#\{\$xajaxDeleteCall\}#');
			$replacements = array($gid,$groupName,$restrictedCategoriesLinks,$xajaxDeleteCall);
			$htmlResponse .= preg_replace($patterns,$replacements,$restrictionTpl);
		}

		$objResponse->assign('restrictions_container','innerHTML',$htmlResponse);

		return $objResponse;
	}
	
	function deleteRestriction($gid){
		$objResponse = new xajaxResponse;
		$file = JPATH_COMPONENT_SITE.DS.'config'.DS.'restrictions.php';
		require($file);
		if(!isset($groupRestrictions)){
			$groupRestrictions = array();
		}
		unset($groupRestrictions[$gid]);
		_rewriteRestrictionsFile($groupRestrictions);
		
		$objResponse->remove('group_'.$gid.'_container');

		return $this->listRestrictions($objResponse);
	}
}

function _rewriteRestrictionsFile($varRestrictions){
		$file = JPATH_COMPONENT_SITE.DS.'config'.DS.'restrictions.php';
		require($file);
		$data='<?php'."\n".
			"defined('_JEXEC') or die('Restricted access.');\n".
			'$groupRestrictions='.var_export($varRestrictions,true).";\n".
			'?>';

		file_put_contents($file,$data);
		
		return true;
	}
?>